/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.backup;

import com.atlassian.config.HomeLocator;
import com.atlassian.crowd.manager.backup.BackupFileStore;
import com.atlassian.crowd.manager.backup.FileToTimestampTransformer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBackupFileStore
implements BackupFileStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultBackupFileStore.class);
    private static final int MAX_BACKUPS = 50;
    private final HomeLocator homeLocator;

    public DefaultBackupFileStore(HomeLocator homeLocator) {
        this.homeLocator = homeLocator;
    }

    @Override
    public void cleanUpAutomatedBackupFiles() {
        List<File> backupFiles = this.getBackupFiles();
        if (backupFiles.size() > 50) {
            int numFilesToDelete = backupFiles.size() - 50;
            log.info("Maximum number of backup files exceeded. Deleting the {} oldest file(s)", (Object)numFilesToDelete);
            List<File> toDelete = backupFiles.subList(0, numFilesToDelete);
            for (File backupFile : toDelete) {
                this.deleteFile(backupFile);
            }
        }
    }

    @Override
    public File getBackupDirectory() {
        String homeDir = this.homeLocator.getHomePath();
        return new File(homeDir, "backups");
    }

    @Override
    public List<File> getBackupFiles() {
        Iterable backupFiles = Iterables.filter(this.filesInBackupDirectory(), this.isAutomatedBackup());
        return Ordering.natural().onResultOf(this.toTimeStamp()).sortedCopy(backupFiles);
    }

    @Override
    public Date extractTimestamp(File file) {
        return (Date)this.toTimeStamp().apply((Object)file);
    }

    protected Function<File, Date> toTimeStamp() {
        return new FileToTimestampTransformer();
    }

    protected Predicate<File> isAutomatedBackup() {
        return Predicates.compose((Predicate)Predicates.notNull(), this.toTimeStamp());
    }

    protected void deleteFile(File file) {
        if (file.delete()) {
            log.info("Deleted backup file {}", (Object)file.getName());
        } else {
            log.error("Could not delete backup file: {}", (Object)file.getName());
        }
    }

    protected Iterable<File> filesInBackupDirectory() {
        File[] files = this.getBackupDirectory().listFiles();
        return files == null ? ImmutableList.of() : Arrays.asList(files);
    }
}

