/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.util.SystemInfoHelper;
import com.atlassian.crowd.util.build.BuildUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.springframework.web.context.ServletContextAware;

public class SystemInfoHelperImpl
implements SystemInfoHelper,
ServletContextAware {
    private ServletContext servletContext;
    private PropertyManager propertyManager;
    private CrowdBootstrapManager bootstrapManager;
    private DirectoryManager directoryManager;

    public SystemInfoHelperImpl() {
    }

    public SystemInfoHelperImpl(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Override
    public String getApplicationServer() {
        String applicationServer = null;
        if (this.servletContext != null) {
            applicationServer = this.servletContext.getServerInfo();
        } else if (ServletActionContext.getServletContext() != null) {
            applicationServer = ServletActionContext.getServletContext().getServerInfo();
        }
        return applicationServer;
    }

    @Override
    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    @Override
    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    @Override
    public long getUsedMemory() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
    }

    @Override
    public String getOperatingSystem() {
        return System.getProperty("os.name") + System.getProperty("os.version");
    }

    @Override
    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @Override
    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    @Override
    public String getJavaRuntime() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getApplicationUsername() {
        return System.getProperty("user.name");
    }

    @Override
    public String getArchitecture() {
        return System.getProperty("os.arch");
    }

    @Override
    public String getCrowdVersion() {
        return BuildUtils.getVersion();
    }

    @Override
    public String getTimeZone() {
        return Calendar.getInstance().getTimeZone().getDisplayName();
    }

    @Override
    public String getJavaVMVersion() {
        return System.getProperty("java.vm.version");
    }

    @Override
    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public String getServerId() {
        return this.getBootstrapManager().getServerID();
    }

    @Override
    public String getDatabaseJdbcDriver() {
        return this.getBootstrapManager().getString("hibernate.connection.driver_class");
    }

    @Override
    public String getDatabaseJdbcUsername() {
        return this.getBootstrapManager().getString("hibernate.connection.username");
    }

    @Override
    public String getDatabaseJdbcUrl() {
        return this.getBootstrapManager().getString("hibernate.connection.url");
    }

    @Override
    public String getDatabaseHibernateDialect() {
        return this.getBootstrapManager().getString("hibernate.dialect");
    }

    @Override
    public String getDatabaseDatasourceJndiName() {
        return this.getBootstrapManager().getString("hibernate.connection.datasource");
    }

    @Override
    public boolean isDatabaseDatasource() {
        return this.getDatabaseDatasourceJndiName() != null;
    }

    @Override
    public void printMinimalSystemInfo(Logger logger) {
        logger.info((Object)"System Information:");
        logger.info((Object)("\tTimezone: " + this.getTimeZone()));
        logger.info((Object)("\tJava Version: " + this.getJavaVersion()));
        logger.info((Object)("\tJava Vendor: " + this.getJavaVendor()));
        logger.info((Object)("\tJVM Version: " + this.getJavaVMVersion()));
        logger.info((Object)("\tJVM Vendor: " + this.getJavaVMVendor()));
        logger.info((Object)("\tJVM Runtime: " + this.getJavaRuntime()));
        logger.info((Object)("\tUsername: " + this.getApplicationUsername()));
        logger.info((Object)("\tOperating System: " + this.getOperatingSystem()));
        logger.info((Object)("\tArchitecture: " + this.getArchitecture()));
        logger.info((Object)"JVM Statistics:");
        logger.info((Object)("\tTotal Memory: " + this.getTotalMemory() + "MB"));
        logger.info((Object)("\tUsed Memory: " + this.getUsedMemory() + "MB"));
        logger.info((Object)("\tFree Memory: " + this.getFreeMemory() + "MB"));
        logger.info((Object)"Runtime Information:");
        logger.info((Object)"\tVersion: 2.4.0");
        logger.info((Object)"\tBuild Number: 562");
        logger.info((Object)"\tBuild Date: 02-01-2012");
    }

    @Override
    public void printSystemInfo(Logger logger) {
        this.printMinimalSystemInfo(logger);
        logger.info((Object)("\tApplication Server: " + this.getApplicationServer()));
        logger.info((Object)"Database Information:");
        if (this.isDatabaseDatasource()) {
            logger.info((Object)("\tDatasource JNDI: " + this.getDatabaseDatasourceJndiName()));
        } else {
            logger.info((Object)("\tJDBC URL: " + this.getDatabaseJdbcUrl()));
            logger.info((Object)("\tJDBC Driver: " + this.getDatabaseJdbcDriver()));
            logger.info((Object)("\tJDBC Username: " + this.getDatabaseJdbcUsername()));
        }
        logger.info((Object)("\tHibernate Dialect: " + this.getDatabaseHibernateDialect()));
        logger.info((Object)"License Information:");
        logger.info((Object)("\tLicense Server ID: " + this.getServerId()));
        logger.info((Object)"Directories:");
        List directories = this.getDirectoryManager().searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        StringBuffer directoryList = new StringBuffer();
        for (Directory directory : directories) {
            String directoryType = directory.getImplementationClass();
            directoryType = directoryType.substring(directoryType.lastIndexOf(".") + 1, directoryType.length());
            directoryList.append("\t").append(directory.getName()).append(" (").append(directoryType).append(")").append("\n");
        }
        logger.info((Object)directoryList.toString());
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public CrowdBootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

