/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UpgradeTask322
implements UpgradeTask {
    private DirectoryManager directoryManager;

    @Override
    public String getBuildNumber() {
        return "322";
    }

    @Override
    public String getShortDescription() {
        return "Adding 'displayName' attribute mapping to non-internal directories";
    }

    @Override
    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            if (directory.getType() == DirectoryType.INTERNAL) continue;
            DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
            directoryToUpdate.setAttribute("ldap.user.displayname", "displayName");
            this.directoryManager.updateDirectory((Directory)directoryToUpdate);
        }
    }

    @Override
    public Collection<String> getErrors() {
        return Collections.emptyList();
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

