/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.database.DatabaseImporter;
import com.atlassian.crowd.migration.legacy.database.sql.LegacyTableQueries;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DatabaseMigrator {
    private static final Logger logger = Logger.getLogger(DatabaseMigrator.class);
    private List<DatabaseImporter> mappers;

    public List<String> importDatabase(LegacyTableQueries legacyTableQueries) {
        LegacyImportDataHolder importData = new LegacyImportDataHolder();
        ArrayList<String> errors = new ArrayList<String>();
        if (legacyTableQueries != null) {
            long startTime = System.currentTimeMillis();
            for (DatabaseImporter mapper : this.mappers) {
                logger.info((Object)("Migrating legacy database using: <" + mapper.getClass().getName() + ">"));
                try {
                    mapper.setLegacyTableQueries(legacyTableQueries);
                    mapper.importFromDatabase(importData);
                }
                catch (ImportException e) {
                    errors.add("Error occurred when migrating database");
                }
            }
            logger.info((Object)("Time taken to migrate legacy database (millis): " + String.valueOf(System.currentTimeMillis() - startTime)));
        } else {
            errors.add("Unable to find the appropriate queries for the database. Automatic migration for this database may not be supported.");
        }
        return errors;
    }

    public void setMappers(List<DatabaseImporter> mappers) {
        this.mappers = mappers;
    }
}

