/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.authentication;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.event.application.ApplicationAuthenticatedEvent;
import com.atlassian.crowd.event.token.TokenInvalidatedEvent;
import com.atlassian.crowd.event.user.UserAuthenticationFailedAccessDeniedEvent;
import com.atlassian.crowd.event.user.UserAuthenticationSucceededEvent;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.TokenExpiredException;
import com.atlassian.crowd.exception.TokenNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.CacheManagerException;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.token.TokenManager;
import com.atlassian.crowd.manager.token.factory.TokenFactory;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.model.authentication.AuthenticationContext;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventPublisher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class TokenAuthenticationManagerImpl
implements TokenAuthenticationManager {
    private static final int MILLIS_IN_MINUTE = 60000;
    private final Logger logger = Logger.getLogger(this.getClass());
    private TokenManager tokenManager;
    private ApplicationDAO applicationDao;
    private TokenFactory tokenFactory;
    private CacheManager cacheManager;
    private EventPublisher eventPublisher;
    private PropertyManager propertyManager;
    private DirectoryManager directoryManager;
    private ApplicationManager applicationManager;
    private ApplicationService applicationService;

    public void invalidateToken(String tokenKey) {
        block3: {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("InvalidateToken: token " + tokenKey));
                }
                Token token = this.tokenManager.findByRandomHash(tokenKey);
                this.logger.debug((Object)"Removing token from the database");
                this.tokenManager.remove(token);
                this.eventPublisher.publish((Object)new TokenInvalidatedEvent((Object)this, token));
            }
            catch (ObjectNotFoundException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)"Token does not exist", (Throwable)e);
            }
        }
    }

    public List<Token> searchTokens(EntityQuery query) {
        return this.tokenManager.search(query);
    }

    public void removeExpiredTokens() {
        long expiration = this.propertyManager.getSessionTime();
        Date expiryTime = new Date(System.currentTimeMillis() - expiration * 60000L);
        this.tokenManager.removeAccessedBefore(expiryTime);
    }

    public User findUserByToken(String tokenKey, String applicationName) throws InvalidTokenException, OperationFailedException, ApplicationAccessDeniedException {
        try {
            Token token = this.tokenManager.findByRandomHash(tokenKey);
            if (token.isApplicationToken()) {
                throw new InvalidTokenException("Found token was for an application, not a user");
            }
            User user = this.directoryManager.findUserByName(token.getDirectoryId(), token.getName());
            if (this.isAllowedToAuthenticate(token, this.applicationManager.findByName(applicationName))) {
                return user;
            }
            throw new ApplicationAccessDeniedException(applicationName);
        }
        catch (UserNotFoundException e) {
            throw new InvalidTokenException(e.getMessage(), (Throwable)e);
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidTokenException(e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new InvalidTokenException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Application> findAuthorisedApplications(User user, String applicationName) throws OperationFailedException, DirectoryNotFoundException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
        List groupMemberships = this.directoryManager.searchNestedGroupRelationships(user.getDirectoryId(), query);
        return this.applicationDao.findAuthorisedApplications(user.getDirectoryId(), groupMemberships);
    }

    public Token authenticateApplication(ApplicationAuthenticationContext authenticationContext) throws InvalidAuthenticationException {
        try {
            Application application = this.applicationDao.findByName(authenticationContext.getName());
            if (!application.isActive()) {
                throw new InvalidAuthenticationException("Application is not active");
            }
            if (!this.applicationManager.authenticate(application, authenticationContext.getCredential())) {
                throw new InvalidAuthenticationException("The password in the application's crowd.properties file does not match the password in Crowd.");
            }
            Token token = this.generateApplicationToken(authenticationContext);
            this.eventPublisher.publish((Object)new ApplicationAuthenticatedEvent((Object)this, application, token));
            return token;
        }
        catch (ApplicationNotFoundException e) {
            throw new InvalidAuthenticationException(authenticationContext.getName(), (Throwable)e);
        }
        catch (InvalidTokenException e) {
            throw new InvalidAuthenticationException(authenticationContext.getName(), (Throwable)e);
        }
    }

    public Token authenticateUser(UserAuthenticationContext authenticationContext, boolean validatePassword, boolean ignoreCache) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        if (authenticationContext == null) {
            throw new InvalidAuthenticationException("Unable to authenticate with null context");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authenticating user: " + authenticationContext.getName()));
        }
        try {
            User user;
            Application application = this.applicationDao.findByName(authenticationContext.getApplication());
            if (validatePassword) {
                user = this.applicationService.authenticateUser(application, authenticationContext.getName(), authenticationContext.getCredential());
            } else {
                user = this.applicationService.findUserByName(application, authenticationContext.getName());
                if (!user.isActive()) {
                    throw new InactiveAccountException(user.getName());
                }
            }
            Token token = this.generateUserToken(user.getDirectoryId(), (AuthenticationContext)authenticationContext);
            if (this.applicationService.isUserAuthorised(application, authenticationContext.getName())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("User <" + authenticationContext.getName() + "> has access to the application <" + application.getName() + ">"));
                }
                this.eventPublisher.publish((Object)new UserAuthenticationSucceededEvent((Object)this, user, application, token));
                return token;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("User <" + authenticationContext.getName() + "> does NOT have access to the application <" + application.getName() + ">"));
            }
            this.eventPublisher.publish((Object)new UserAuthenticationFailedAccessDeniedEvent((Object)this, user, application));
            throw new ApplicationAccessDeniedException(authenticationContext.getApplication());
        }
        catch (ApplicationNotFoundException e) {
            throw new InvalidAuthenticationException(authenticationContext.getName(), (Throwable)e);
        }
        catch (InvalidTokenException e) {
            throw new InvalidAuthenticationException(authenticationContext.getName(), (Throwable)e);
        }
        catch (CacheManagerException e) {
            throw new InvalidAuthenticationException(authenticationContext.getName(), (Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new InvalidAuthenticationException(authenticationContext.getName(), (Throwable)e);
        }
    }

    public Token authenticateUser(UserAuthenticationContext authenticateContext) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        return this.authenticateUser(authenticateContext, true, false);
    }

    public Token authenticateUserWithoutValidatingPassword(UserAuthenticationContext authenticateContext) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, ApplicationAccessDeniedException {
        try {
            return this.authenticateUser(authenticateContext, false, false);
        }
        catch (ExpiredCredentialException e) {
            this.logger.fatal((Object)"This should never happen! This user is not authenticated by validating the password.");
            throw InvalidAuthenticationException.newInstanceWithName((String)authenticateContext.getName());
        }
    }

    public Token validateApplicationToken(String tokenKey, ValidationFactor[] clientValidationFactors) throws InvalidTokenException {
        return this.genericValidateToken(tokenKey, clientValidationFactors);
    }

    public Token validateUserToken(String userTokenKey, ValidationFactor[] validationFactors, String applicationName) throws InvalidTokenException, ApplicationAccessDeniedException, OperationFailedException {
        Application application;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("validateUserToken: " + userTokenKey));
        }
        Token validatedToken = this.genericValidateToken(userTokenKey, validationFactors);
        try {
            application = this.applicationDao.findByName(applicationName);
        }
        catch (ObjectNotFoundException e) {
            throw new ApplicationAccessDeniedException(applicationName);
        }
        try {
            if (this.isAllowedToAuthenticate(validatedToken, application)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("user has access to the application <" + application.getName() + ">"));
                }
                return validatedToken;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("user does NOT have access to the application <" + application.getName() + ">"));
            }
            throw new ApplicationAccessDeniedException(applicationName);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping removed while validating the user token");
        }
    }

    protected Token generateUserToken(long directoryID, AuthenticationContext authenticationContext) throws InvalidTokenException {
        ValidationFactor[] factors;
        Assert.notNull((Object)authenticationContext);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("generateUserToken: user " + authenticationContext.getName()));
        }
        if ((factors = authenticationContext.getValidationFactors()) == null) {
            factors = new ValidationFactor[]{};
        }
        Token token = this.tokenFactory.create(directoryID, authenticationContext.getName(), new ArrayList<ValidationFactor>(Arrays.asList(factors)));
        try {
            Token existingToken = this.tokenManager.findByIdentifierHash(token.getIdentifierHash());
            if (this.isExpired(existingToken)) {
                this.logger.debug((Object)"Token exists matching identifierHash, but is expired, so need to create a new token");
                this.tokenManager.remove(existingToken);
                throw new ObjectNotFoundException(Token.class, (Object)token.getIdentifierHash());
            }
            token = this.tokenManager.update(existingToken);
            this.logger.debug((Object)"Returning existing token that matched identifierHash");
        }
        catch (ObjectNotFoundException e) {
            this.tokenManager.add(token);
            this.logger.debug((Object)"Returning newly created token");
        }
        return token;
    }

    protected Token generateApplicationToken(ApplicationAuthenticationContext authenticationContext) throws InvalidTokenException {
        return this.generateUserToken(-1L, (AuthenticationContext)authenticationContext);
    }

    protected Token genericValidateToken(String token, ValidationFactor[] validationFactors) throws InvalidTokenException {
        Assert.notNull((Object)token, (String)"A token key cannot be null");
        Assert.notNull((Object)validationFactors, (String)"The array of ValidationFactors cannot be null");
        this.logger.debug((Object)"genericValidateToken");
        try {
            Token existingToken = this.tokenManager.findByRandomHash(token);
            if (this.isExpired(existingToken)) {
                this.logger.debug((Object)"token has expired. removing from db");
                this.tokenManager.remove(existingToken);
                throw new TokenExpiredException("Token has expired.");
            }
            Token validationToken = this.tokenFactory.create(existingToken.getDirectoryId(), existingToken.getName(), new ArrayList<ValidationFactor>(Arrays.asList(validationFactors)), existingToken.getRandomNumber());
            if (this.logger.isDebugEnabled()) {
                StringBuffer message = new StringBuffer("Current Validation Factors: \n");
                for (int i = 0; i < validationFactors.length; ++i) {
                    ValidationFactor validationFactor = validationFactors[i];
                    message.append(validationFactor);
                }
                this.logger.debug((Object)message.toString());
                this.logger.debug((Object)("comparing existing token " + existingToken + " with a validation token " + validationToken));
            }
            if (!existingToken.getRandomHash().equals(validationToken.getRandomHash())) {
                this.logger.debug((Object)"The token keys don't match");
                throw new InvalidTokenException("Token doesn't match the existing token.");
            }
            this.logger.debug((Object)"returning validated token, with updated last accessed time");
            return this.tokenManager.update(existingToken);
        }
        catch (ObjectNotFoundException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The token " + token + " was not found in db"));
            }
            throw new TokenNotFoundException("Token does not validate.");
        }
    }

    protected boolean isExpired(Token token) {
        long now = System.currentTimeMillis();
        long timeSpread = now - token.getLastAccessedDate().getTime();
        long allowedElapse = 60000L * this.propertyManager.getSessionTime();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"checking if the token is expired:");
            this.logger.debug((Object)("\tnow: \t\t\t" + now));
            this.logger.debug((Object)("\tlast accessed: \t" + token.getLastAccessedDate()));
            this.logger.debug((Object)("\tdifference: \t" + timeSpread));
            this.logger.debug((Object)("\tallowed elapse: " + allowedElapse));
        }
        return timeSpread > allowedElapse;
    }

    public boolean isAllowedToAuthenticate(String username, long directoryId, Application application) throws OperationFailedException, DirectoryNotFoundException {
        if (!application.isActive()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("User does not have access to application '" + application.getName() + "' as the application is inactive"));
            }
            return false;
        }
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping != null) {
            if (directoryMapping.isAllowAllToAuthenticate()) {
                return true;
            }
            for (GroupMapping groupMapping : directoryMapping.getAuthorisedGroups()) {
                if (!this.directoryManager.isUserNestedGroupMember(directoryId, username, groupMapping.getGroupName())) continue;
                return true;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("User does not have access to application '" + application.getName() + "' as the directory is not allow all to authenticate and the user is not a member of any of the authorised groups"));
        }
        return false;
    }

    public boolean isAllowedToAuthenticate(Token token, Application application, boolean ignoreCache) throws OperationFailedException, DirectoryNotFoundException {
        if (ignoreCache || !this.propertyManager.isCacheEnabled()) {
            return this.isAllowedToAuthenticate(token.getName(), token.getDirectoryId(), application);
        }
        try {
            Boolean hasAccess = (Boolean)this.cacheManager.get(application.getName() + token.getRandomHash());
            if (hasAccess.booleanValue()) {
                return true;
            }
        }
        catch (NotInCacheException e) {
            // empty catch block
        }
        boolean hasAccess = this.isAllowedToAuthenticate(token.getName(), token.getDirectoryId(), application);
        this.cacheManager.put(application.getName() + token.getRandomHash(), (Serializable)Boolean.valueOf(hasAccess));
        return hasAccess;
    }

    public boolean isAllowedToAuthenticate(Token token, Application application) throws OperationFailedException, DirectoryNotFoundException {
        return this.isAllowedToAuthenticate(token, application, false);
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void setApplicationDao(ApplicationDAO applicationDao) {
        this.applicationDao = applicationDao;
    }

    public void setTokenFactory(TokenFactory tokenFactory) {
        this.tokenFactory = tokenFactory;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }
}

