/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.authentication;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.AliasManager;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import java.util.List;

public class AliasingAwareTokenAuthenticationManager
implements TokenAuthenticationManager {
    private final TokenAuthenticationManager tokenAuthenticationManager;
    private final ApplicationManager applicationManager;
    private final AliasManager aliasManager;

    public AliasingAwareTokenAuthenticationManager(TokenAuthenticationManager tokenAuthenticationManager, ApplicationManager applicationManager, AliasManager aliasManager) {
        this.tokenAuthenticationManager = tokenAuthenticationManager;
        this.applicationManager = applicationManager;
        this.aliasManager = aliasManager;
    }

    public Token authenticateApplication(ApplicationAuthenticationContext authenticationContext) throws InvalidAuthenticationException {
        return this.tokenAuthenticationManager.authenticateApplication(authenticationContext);
    }

    public Token authenticateUser(UserAuthenticationContext authenticateContext) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException, ApplicationNotFoundException {
        Application application = this.applicationManager.findByName(authenticateContext.getApplication());
        String username = this.aliasManager.findUsernameByAlias(application, authenticateContext.getName());
        UserAuthenticationContext aliasedAuthenticateContext = new UserAuthenticationContext(username, authenticateContext.getCredential(), authenticateContext.getValidationFactors(), authenticateContext.getApplication());
        return this.tokenAuthenticationManager.authenticateUser(aliasedAuthenticateContext);
    }

    public Token authenticateUserWithoutValidatingPassword(UserAuthenticationContext authenticateContext) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, ApplicationAccessDeniedException, ApplicationNotFoundException {
        Application application = this.applicationManager.findByName(authenticateContext.getApplication());
        String username = this.aliasManager.findUsernameByAlias(application, authenticateContext.getName());
        UserAuthenticationContext aliasedAuthenticateContext = new UserAuthenticationContext(username, authenticateContext.getCredential(), authenticateContext.getValidationFactors(), authenticateContext.getApplication());
        return this.tokenAuthenticationManager.authenticateUserWithoutValidatingPassword(aliasedAuthenticateContext);
    }

    public Token validateApplicationToken(String tokenKey, ValidationFactor[] validationFactors) throws InvalidTokenException {
        return this.tokenAuthenticationManager.validateApplicationToken(tokenKey, validationFactors);
    }

    public Token validateUserToken(String userTokenKey, ValidationFactor[] validationFactors, String application) throws InvalidTokenException, ApplicationAccessDeniedException, OperationFailedException {
        return this.tokenAuthenticationManager.validateUserToken(userTokenKey, validationFactors, application);
    }

    public void invalidateToken(String token) {
        this.tokenAuthenticationManager.invalidateToken(token);
    }

    public List<Token> searchTokens(EntityQuery<Token> query) {
        return this.tokenAuthenticationManager.searchTokens(query);
    }

    public void removeExpiredTokens() {
        this.tokenAuthenticationManager.removeExpiredTokens();
    }

    public User findUserByToken(String key, String applicationName) throws InvalidTokenException, OperationFailedException, ApplicationNotFoundException, ApplicationAccessDeniedException {
        Application application = this.applicationManager.findByName(applicationName);
        UserTemplate user = new UserTemplate(this.tokenAuthenticationManager.findUserByToken(key, applicationName));
        String alias = this.aliasManager.findAliasByUsername(application, user.getName());
        String username = application.isLowerCaseOutput() ? IdentifierUtils.toLowerCase((String)alias) : alias;
        user.setName(username);
        return user;
    }

    public List<Application> findAuthorisedApplications(User user, String applicationName) throws OperationFailedException, DirectoryNotFoundException, ApplicationNotFoundException {
        Application application = this.applicationManager.findByName(applicationName);
        UserTemplate userTemplate = new UserTemplate(user);
        userTemplate.setName(this.aliasManager.findUsernameByAlias(application, user.getName()));
        return this.tokenAuthenticationManager.findAuthorisedApplications((User)userTemplate, applicationName);
    }
}

