/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.BaseDelegatingJdbcImporter;
import com.atlassian.crowd.importer.importers.ConfluenceHibernateImporter;
import com.atlassian.crowd.importer.importers.ConfluenceOSUserImporter;
import com.atlassian.crowd.importer.importers.CrowdifiedConfluenceImporter;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.importers.JdbcImporter;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.util.PasswordHelper;
import org.springframework.jdbc.BadSqlGrammarException;

public class ConfluenceImporter
extends BaseDelegatingJdbcImporter {
    private static final String CROWD_USER_COUNT = "SELECT COUNT(id)  FROM cwd_user";
    private static final String HIBERNATE_USER_COUNT = "SELECT COUNT(id) FROM users";

    public ConfluenceImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        super(directoryManager, passwordHelper);
    }

    public Importer determineImporter(Configuration configuration) throws ImporterException {
        if (configuration == null || !this.getConfigurationType().isInstance(configuration)) {
            throw new IllegalArgumentException("The supplied configuration was of the incorrect type for this Importer, should of been: " + this.getConfigurationType().getCanonicalName());
        }
        this.init(configuration);
        JdbcImporter confluenceImporter = this.isUsingCrowdUser() ? new CrowdifiedConfluenceImporter(this.directoryManager, this.passwordHelper) : (this.isUsingHibernateUser() ? new ConfluenceHibernateImporter(this.directoryManager, this.passwordHelper) : new ConfluenceOSUserImporter(this.directoryManager, this.passwordHelper));
        return confluenceImporter;
    }

    private boolean isUsingCrowdUser() {
        try {
            return this.jdbcTemplate.queryForInt(CROWD_USER_COUNT) > 0;
        }
        catch (BadSqlGrammarException bsge) {
            return false;
        }
    }

    private boolean isUsingHibernateUser() {
        return this.jdbcTemplate.queryForInt(HIBERNATE_USER_COUNT) > 0;
    }
}

