/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask429
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask429.class);
    private final Collection<String> errors = new ArrayList<String>();
    private DirectoryDao directoryDao;

    @Override
    public String getBuildNumber() {
        return "429";
    }

    @Override
    public String getShortDescription() {
        return "Upgrading directories having InternalDirectoryWithBatching as an implementation class to use " + InternalDirectory.class.getSimpleName() + " as an implementation class.";
    }

    @Override
    public void doUpgrade() throws Exception {
        for (Directory directory : this.findAllConnectorDirectories()) {
            log.debug("Upgrading directory {}", (Object)directory);
            try {
                this.updateDirectory(directory);
            }
            catch (DataAccessException e) {
                String errorMessage = "Could not update directory " + directory;
                log.error(errorMessage, (Throwable)e);
                this.errors.add(errorMessage + ", error is " + e.getMessage());
            }
        }
    }

    private void updateDirectory(Directory directory) throws DataAccessException, DirectoryNotFoundException {
        DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
        directoryToUpdate.setImplementationClass(InternalDirectory.class.getName());
        this.directoryDao.update((Directory)directoryToUpdate);
    }

    private List<Directory> findAllConnectorDirectories() {
        return this.directoryDao.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.IMPLEMENTATION_CLASS).exactlyMatching((Object)"com.atlassian.crowd.directory.InternalDirectoryWithBatching")).returningAtMost(-1));
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }
}

