/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.soap;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.integration.authentication.AuthenticatedToken;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.validation.ClientValidationException;
import com.atlassian.crowd.manager.validation.ClientValidationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.SoapObjectTranslator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.codehaus.xfire.transport.http.XFireServletController;

public class SOAPService {
    private static final Logger logger = Logger.getLogger(SOAPService.class);
    private ApplicationManager applicationManager;
    private TokenAuthenticationManager tokenAuthenticationManager;
    private CrowdLicenseManager crowdLicenseManager;
    private I18nHelper i18nHelper;
    private ClientValidationManager clientValidationManager;

    public ValidationFactor[] getApplicationClientValidationFactors(String name) {
        HttpServletRequest request = this.getClientRequest();
        String remoteAddress = request.getRemoteAddr();
        String remoteHost = request.getRemoteHost();
        ArrayList<ValidationFactor> validationFactors = new ArrayList<ValidationFactor>();
        validationFactors.add(new ValidationFactor("remote_address", remoteAddress));
        validationFactors.add(new ValidationFactor("remote_host", remoteHost));
        validationFactors.add(new ValidationFactor("NAME", name));
        String remoteAddressXForwardFor = request.getHeader("X-Forwarded-For");
        if (remoteAddressXForwardFor != null && !remoteAddressXForwardFor.equals(remoteAddress)) {
            validationFactors.add(new ValidationFactor("X-Forwarded-For", remoteAddressXForwardFor));
        }
        return validationFactors.toArray(new ValidationFactor[validationFactors.size()]);
    }

    public Application validateSOAPService(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            logger.debug((Object)"validating license key");
            this.validateLicense();
            logger.debug((Object)("validating application token: " + applicationToken.getToken()));
            Token token = this.tokenAuthenticationManager.validateApplicationToken(applicationToken.getToken(), SoapObjectTranslator.fromSoapValidationFactors((ValidationFactor[])this.getApplicationClientValidationFactors(applicationToken.getName())));
            logger.debug((Object)("loading application: " + token.getName()));
            Application application = this.applicationManager.findByName(token.getName());
            this.clientValidationManager.validate(application, this.getClientRequest());
            return application;
        }
        catch (InvalidTokenException e) {
            throw new InvalidAuthorizationTokenException(this.i18nHelper.getText("soapservice.authenticationinvalid.exception"), (Throwable)e);
        }
        catch (ApplicationNotFoundException e) {
            throw new InvalidAuthorizationTokenException(this.i18nHelper.getText("soapservice.authenticationinvalid.exception"), (Throwable)e);
        }
        catch (ClientValidationException e) {
            throw new InvalidAuthorizationTokenException(e.getMessage());
        }
    }

    private HttpServletRequest getClientRequest() {
        return XFireServletController.getRequest();
    }

    protected void validateLicense() throws RemoteException {
        if (!this.crowdLicenseManager.isLicenseValid()) {
            throw new RemoteException(this.i18nHelper.getText("soapservice.licenseinvalid.exception"));
        }
    }

    public void setCrowdLicenseManager(CrowdLicenseManager crowdLicenseManager) {
        this.crowdLicenseManager = crowdLicenseManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public void setTokenAuthenticationManager(TokenAuthenticationManager tokenAuthenticationManager) {
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    public void setClientValidationManager(ClientValidationManager clientValidationManager) {
        this.clientValidationManager = clientValidationManager;
    }
}

