/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import com.atlassian.config.ApplicationConfig;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.database.DatabaseMigrator;
import com.atlassian.crowd.migration.legacy.database.sql.HSQLLegacyTableQueries;
import com.atlassian.crowd.migration.legacy.database.sql.LegacyTableQueries;
import com.atlassian.crowd.migration.legacy.database.sql.MySQLLegacyTableQueries;
import com.atlassian.crowd.migration.legacy.database.sql.PostgresLegacyTableQueries;
import com.atlassian.crowd.migration.legacy.database.sql.SqlServerLegacyTableQueries;
import com.atlassian.crowd.migration.verify.DatabaseVerificationManager;
import com.atlassian.crowd.migration.verify.SupportedDatabaseVerifier;
import com.atlassian.crowd.util.SystemInfoHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseMigrationManager {
    private static final Logger logger = Logger.getLogger(DatabaseMigrationManager.class);
    private final LegacyTableQueries legacyTableQueries;
    private final DatabaseMigrator legacyDatabaseMigrator;
    private final ApplicationConfig applicationConfig;
    private final DatabaseVerificationManager verificationManager;

    public DatabaseMigrationManager(DatabaseMigrator legacyDatabaseMigrator, ApplicationConfig applicationConfig, DatabaseVerificationManager verificationManager, SystemInfoHelper systemInfoHelper) {
        this.legacyDatabaseMigrator = legacyDatabaseMigrator;
        this.applicationConfig = applicationConfig;
        this.verificationManager = verificationManager;
        this.legacyTableQueries = this.getTableQueryForDriver(systemInfoHelper.getDatabaseHibernateDialect());
    }

    public Collection<String> doDatabaseMigration() throws ImportException {
        logger.info((Object)"Migrating existing data from legacy database into new schema.");
        return Lists.newArrayList(this.legacyDatabaseMigrator.importDatabase(this.legacyTableQueries));
    }

    public Collection<String> verifyDatabaseIsSafeToMigrate() {
        ArrayList errors = Lists.newArrayList();
        if (this.isLegacyCrowd()) {
            logger.info((Object)("Legacy Crowd version detected <" + this.applicationConfig.getBuildNumber() + ">."));
            this.verificationManager.setLegacyTableQueries(this.legacyTableQueries);
            errors.addAll(this.verificationManager.validate());
            if (!errors.isEmpty()) {
                logger.error((Object)("An in-place upgrade is not possible for your database, for the following reasons: " + StringUtils.join((Collection)errors, (String)"\n")));
            }
        }
        return errors;
    }

    public boolean isLegacyCrowd() {
        int buildNumber = NumberUtils.toInt((String)this.applicationConfig.getBuildNumber());
        return buildNumber > 0 && buildNumber < 395;
    }

    private LegacyTableQueries getTableQueryForDriver(String hibernateDialect) {
        if (SupportedDatabaseVerifier.isPostgreSQL(hibernateDialect)) {
            return new PostgresLegacyTableQueries();
        }
        if (SupportedDatabaseVerifier.isMySQL(hibernateDialect)) {
            return new MySQLLegacyTableQueries();
        }
        if (SupportedDatabaseVerifier.isHSQLDB(hibernateDialect)) {
            return new HSQLLegacyTableQueries();
        }
        if (SupportedDatabaseVerifier.isMsSQLServer(hibernateDialect)) {
            return new SqlServerLegacyTableQueries();
        }
        logger.warn((Object)("No LegacyTablesQuery available for: " + hibernateDialect));
        return null;
    }
}

