/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.token;

import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.manager.token.TokenManager;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenManagerImpl
implements TokenManager {
    private final Logger logger = Logger.getLogger(TokenManagerImpl.class);
    private final ReentrantReadWriteLock readWriteLock;
    private TokenDAO implementation;
    private final TokenDAO daoMemory;
    private final TokenDAO daoHibernate;
    private final PropertyManager propertyManager;

    public TokenManagerImpl(boolean initialUseIsMemory, TokenDAO daoMemory, TokenDAO daoHibernate, PropertyManager propertyManager, EventPublisher eventPublisher) {
        this.daoMemory = (TokenDAO)Preconditions.checkNotNull((Object)daoMemory);
        this.daoHibernate = (TokenDAO)Preconditions.checkNotNull((Object)daoHibernate);
        this.propertyManager = (PropertyManager)Preconditions.checkNotNull((Object)propertyManager);
        this.implementation = initialUseIsMemory ? daoMemory : daoHibernate;
        this.readWriteLock = new ReentrantReadWriteLock();
        eventPublisher.register((Object)this);
    }

    public TokenManagerImpl(TokenDAO daoMemory, TokenDAO daoHibernate, PropertyManager propertyManager, EventPublisher eventPublisher) {
        this(Boolean.FALSE, daoMemory, daoHibernate, propertyManager, eventPublisher);
    }

    private void lockRead() {
        this.readWriteLock.readLock().lock();
    }

    private void unlockRead() {
        this.readWriteLock.readLock().unlock();
    }

    private void lockWrite() {
        this.readWriteLock.writeLock().lock();
    }

    private void unlockWrite() {
        this.readWriteLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token findByRandomHash(String randomHash) throws DataAccessException, ObjectNotFoundException {
        try {
            this.lockRead();
            Token token = this.implementation.findByRandomHash(randomHash);
            return token;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token findByIdentifierHash(String identifierHash) throws ObjectNotFoundException {
        try {
            this.lockRead();
            Token token = this.implementation.findByIdentifierHash(identifierHash);
            return token;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token add(Token token) throws DataAccessException {
        try {
            this.lockRead();
            Token token2 = this.implementation.add(token);
            return token2;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token update(Token token) throws ObjectNotFoundException {
        try {
            this.lockRead();
            Token token2 = this.implementation.update(token);
            return token2;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Token token) throws DataAccessException {
        try {
            this.lockRead();
            this.implementation.remove(token);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Token> search(EntityQuery query) {
        try {
            this.lockRead();
            List list = this.implementation.search(query);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token findByID(long ID) throws DataAccessException, ObjectNotFoundException {
        try {
            this.lockRead();
            Token token = this.implementation.findByID(ID);
            return token;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(long directoryID, String name) throws DataAccessException {
        try {
            this.lockRead();
            this.implementation.remove(directoryID, name);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(long directoryId) {
        try {
            this.lockRead();
            this.implementation.removeAll(directoryId);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccessedBefore(Date expiryTime) {
        try {
            this.lockRead();
            this.implementation.removeAccessedBefore(expiryTime);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        try {
            this.lockRead();
            this.daoMemory.removeAll();
            this.daoHibernate.removeAll();
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public boolean isUsingDatabaseStorage() {
        return this.implementation == this.daoHibernate;
    }

    @Override
    public void setUsingDatabaseStorage(boolean useDatabaseStorage) throws PropertyManagerException {
        this.propertyManager.setUsingDatabaseTokenStorage(useDatabaseStorage);
        if (useDatabaseStorage) {
            if (!this.isUsingDatabaseStorage()) {
                this.switchToHibernate();
            }
        } else if (this.isUsingDatabaseStorage()) {
            this.switchToMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToMemory() {
        this.logger.info((Object)"About to switch to in-memory token storage");
        try {
            this.lockWrite();
            if (this.implementation != this.daoHibernate) {
                throw new IllegalStateException("Cannot switch; already in memory caching mode");
            }
            this.move(this.daoMemory, this.daoHibernate);
            this.implementation = this.daoMemory;
        }
        finally {
            this.unlockWrite();
        }
        this.logger.info((Object)"Finished switch to in-memory token storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToHibernate() {
        try {
            this.logger.info((Object)"About to switch to database token storage");
            this.lockWrite();
            if (this.implementation != this.daoMemory) {
                throw new IllegalStateException("Cannot switch; already in database caching mode");
            }
            this.move(this.daoHibernate, this.daoMemory);
            this.implementation = this.daoHibernate;
        }
        finally {
            this.unlockWrite();
        }
        this.logger.info((Object)"Finished switch to database token storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void move(TokenDAO to, TokenDAO from) {
        try {
            this.lockWrite();
            Collection tokens = from.loadAll();
            if (tokens != null) {
                to.saveAll(tokens);
                from.removeAll();
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent event) {
        this.updateTokenStorage();
    }

    @EventListener
    public void onXMLRestoreFinishedEvent(XMLRestoreFinishedEvent event) {
        this.updateTokenStorage();
    }

    private void updateTokenStorage() {
        try {
            this.setUsingDatabaseStorage(this.propertyManager.isUsingDatabaseTokenStorage());
        }
        catch (PropertyManagerException e) {
            this.logger.error((Object)"Failed to set token storage on application startup", (Throwable)e);
        }
    }
}

