/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.manager;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterConfigurationException;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.factory.ImporterFactory;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.manager.ImporterManager;
import com.atlassian.crowd.importer.model.Result;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImporterManagerImpl
implements ImporterManager {
    private ImporterFactory importerFactory;

    @Override
    public Result performImport(Configuration configuration) throws ImporterException {
        if (configuration == null) {
            throw new IllegalArgumentException("You cannot supply a null Configuration");
        }
        configuration.isValid();
        Importer importer = this.importerFactory.getImporterDAO(configuration);
        return importer.importUsersGroupsAndMemberships(configuration);
    }

    @Override
    public boolean supportsMultipleDirectories(Configuration configuration) throws ImporterException {
        if (configuration == null) {
            throw new IllegalArgumentException("You cannot supply a null Configuration");
        }
        configuration.isValid();
        Importer importer = this.importerFactory.getImporterDAO(configuration);
        return importer.supportsMultipleDirectories(configuration);
    }

    @Override
    public Set<Directory> retrieveRemoteSourceDirectories(Configuration configuration) throws ImporterException {
        if (configuration == null) {
            throw new IllegalArgumentException("You cannot supply a null Configuration");
        }
        configuration.isValid();
        Importer importer = this.importerFactory.getImporterDAO(configuration);
        return importer.retrieveRemoteSourceDirectory(configuration);
    }

    @Override
    public void testConfiguration(Configuration configuration) throws ImporterConfigurationException {
        configuration.isValid();
    }

    @Override
    public Set<String> getSupportedApplications() {
        return this.importerFactory.getSupportedImporterApplications();
    }

    @Override
    public Set<String> getAtlassianSupportedApplications() {
        return this.importerFactory.getAtlassianSupportedImporterApplications();
    }

    public void setImporterFactory(ImporterFactory importerFactory) {
        this.importerFactory = importerFactory;
    }
}

