/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event.listener;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.event.api.EventListener;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AutoGroupAdderListener {
    private final Logger logger = Logger.getLogger(this.getClass());
    private DirectoryInstanceLoader directoryInstanceLoader;

    @EventListener
    public void handleEvent(UserCreatedEvent event) {
        Directory directory = event.getDirectory();
        String concatenatedGroupNames = directory.getValue("autoAddGroups");
        if (directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP) && StringUtils.isNotBlank((String)concatenatedGroupNames)) {
            List<String> groups = Arrays.asList(concatenatedGroupNames.split("\\|"));
            try {
                RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getDirectory(directory);
                for (String groupName : groups) {
                    try {
                        remoteDirectory.addUserToGroup(event.getUser().getName(), groupName);
                    }
                    catch (GroupNotFoundException e) {
                        this.logger.error((Object)("Could not auto add user to group: " + e.getMessage()), (Throwable)e);
                    }
                    catch (OperationFailedException e) {
                        this.logger.error((Object)("Could not access directory: " + e.getMessage()), (Throwable)e);
                    }
                    catch (UserNotFoundException e) {
                        this.logger.error((Object)("Could not auto add user to group: " + e.getMessage()), (Throwable)e);
                    }
                    catch (ReadOnlyGroupException e) {
                        this.logger.error((Object)("Could not auto add user to group: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            catch (DirectoryInstantiationException e) {
                this.logger.error((Object)("Could not instantiate directory: " + e.getMessage()), (Throwable)e);
            }
        } else if (StringUtils.isNotBlank((String)concatenatedGroupNames)) {
            this.logger.error((Object)("You have groups <" + concatenatedGroupNames + "> to be auto-added for the user <" + event.getUser().getName() + ">, but the directory does not have permission for Group updates."));
        }
    }

    public void setDirectoryInstanceLoader(DirectoryInstanceLoader directoryInstanceLoader) {
        this.directoryInstanceLoader = directoryInstanceLoader;
    }
}

