/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.validation;

import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class XForwardedForUtil {
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";

    private XForwardedForUtil() {
    }

    public static InetAddress getTrustedAddress(TrustedProxyManager trustedProxyManager, HttpServletRequest request) {
        String trustedAddress = XForwardedForUtil.getTrustedAddress(trustedProxyManager, request.getRemoteAddr(), request.getHeader(X_FORWARDED_FOR));
        try {
            return InetAddress.getByName(trustedAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTrustedAddress(TrustedProxyManager trustedProxyManager, String requestAddress, String xForwardedFor) {
        ArrayList chain = Lists.newArrayList((Object[])StringUtils.split((String)Strings.nullToEmpty((String)xForwardedFor), (String)", "));
        chain.add(requestAddress);
        return chain.subList(1, chain.size()).stream().allMatch(trustedProxyManager::isTrusted) ? (String)chain.get(0) : requestAddress;
    }
}

