package com.atlassian.crowd.manager.application;

import java.util.List;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.constants.ApplicationTermKeys;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;


public class InternalApplicationHelperImpl implements InternalApplicationHelper {
    private final ApplicationManager applicationManager;

    public InternalApplicationHelperImpl(ApplicationManager applicationManager) {
        this.applicationManager = Preconditions.checkNotNull(applicationManager);
    }

    @Override
    public Application findCrowdConsoleApplication() throws RuntimeException {
        List<Application> crowdApplications = applicationManager.search(QueryBuilder.queryFor(Application.class,
                EntityDescriptor.application(), Restriction.on(ApplicationTermKeys.TYPE).exactlyMatching(ApplicationType.CROWD), 0, EntityQuery.ALL_RESULTS));

        return Iterables.getOnlyElement(crowdApplications);
    }
}
