/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.RemoteAddress;
import java.io.Serializable;

public class RemoteAddressCacheUtil {
    public static final String REMOTE_ADDRESS_CACHE_NAME = Application.class.toString() + RemoteAddress.class.toString() + "cache";
    private final CacheManager cacheManager;

    public RemoteAddressCacheUtil(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setPermitted(Application application, RemoteAddress remoteAddress, boolean permitted) {
        String key = RemoteAddressCacheUtil.getKeyName(application, remoteAddress);
        this.cacheManager.put(REMOTE_ADDRESS_CACHE_NAME, (Serializable)((Object)key), (Serializable)Boolean.valueOf(permitted));
    }

    public boolean getPermitted(Application application, RemoteAddress remoteAddress) throws NotInCacheException {
        String key = RemoteAddressCacheUtil.getKeyName(application, remoteAddress);
        Boolean permitted = (Boolean)this.cacheManager.get(REMOTE_ADDRESS_CACHE_NAME, (Serializable)((Object)key));
        return permitted != null && permitted != false;
    }

    public void clearCache() {
        this.cacheManager.removeAll(REMOTE_ADDRESS_CACHE_NAME);
    }

    private static String getKeyName(Application application, RemoteAddress remoteAddress) {
        return application.getName() + "#" + remoteAddress.getAddress();
    }
}

