package com.atlassian.crowd.model.licensing;

import com.atlassian.crowd.model.application.Application;
import com.google.common.base.MoreObjects;

import java.util.Date;
import java.util.Objects;

public class ApplicationLicensingSummary {

    private final Date generatedOn;
    private final long versionId;
    private final Application application;
    private final String applicationSubtype;
    private final int totalUsers;
    private final int totalUsersFromLocalCrowd;
    private final boolean active;
    private final int maximumUserLimit;
    private final int totalDirectories;

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    protected ApplicationLicensingSummary(Date generatedOn, long versionId, Application application, String applicationSubtype, int totalUsers, int totalUsersFromLocalCrowd, boolean active, int maximumUserLimit, int totalDirectories) {
        this.generatedOn = Objects.requireNonNull(generatedOn);
        this.versionId = versionId;
        this.application = Objects.requireNonNull(application);
        this.applicationSubtype = applicationSubtype;
        this.totalUsers = totalUsers;
        this.totalUsersFromLocalCrowd = totalUsersFromLocalCrowd;
        this.active = active;
        this.maximumUserLimit = maximumUserLimit;
        this.totalDirectories = totalDirectories;
    }

    public Date getGeneratedOn() {
        return generatedOn;
    }

    public long getVersionId() {
        return versionId;
    }

    public Application getApplication() {
        return application;
    }

    public String getApplicationSubtype() {
        return applicationSubtype;
    }

    public int getTotalUsers() {
        return totalUsers;
    }

    public int getTotalUsersFromLocalCrowd() {
        return totalUsersFromLocalCrowd;
    }

    public boolean isActive() {
        return active;
    }

    public int getMaximumUserLimit() {
        return maximumUserLimit;
    }

    public int getTotalDirectories() {
        return totalDirectories;
    }

    public static ApplicationLicensingSummary.Builder builder() {
        return new ApplicationLicensingSummary.Builder();
    }

    public static ApplicationLicensingSummary.Builder builder(ApplicationLicensingSummary data) {
        return new ApplicationLicensingSummary.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ApplicationLicensingSummary that = (ApplicationLicensingSummary) o;

        return Objects.equals(this.getGeneratedOn(), that.getGeneratedOn()) && Objects.equals(this.getVersionId(), that.getVersionId()) && Objects.equals(this.getApplication(), that.getApplication()) && Objects.equals(this.getApplicationSubtype(), that.getApplicationSubtype()) && Objects.equals(this.getTotalUsers(), that.getTotalUsers()) && Objects.equals(this.getTotalUsersFromLocalCrowd(), that.getTotalUsersFromLocalCrowd()) && Objects.equals(this.isActive(), that.isActive()) && Objects.equals(this.getMaximumUserLimit(), that.getMaximumUserLimit()) && Objects.equals(this.getTotalDirectories(), that.getTotalDirectories());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getGeneratedOn(), getVersionId(), getApplication(), getApplicationSubtype(), getTotalUsers(), getTotalUsersFromLocalCrowd(), isActive(), getMaximumUserLimit(), getTotalDirectories());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("generatedOn", getGeneratedOn())
                .add("versionId", getVersionId())
                .add("application", getApplication())
                .add("applicationSubtype", getApplicationSubtype())
                .add("totalUsers", getTotalUsers())
                .add("totalUsersFromLocalCrowd", getTotalUsersFromLocalCrowd())
                .add("active", isActive())
                .add("maximumUserLimit", getMaximumUserLimit())
                .add("totalDirectories", getTotalDirectories())
                .toString();
    }

    public static final class Builder {

        private Date generatedOn;
        private long versionId;
        private Application application;
        private String applicationSubtype;
        private int totalUsers;
        private int totalUsersFromLocalCrowd;
        private boolean active;
        private int maximumUserLimit;
        private int totalDirectories;

        private Builder() {
        }

        private Builder(ApplicationLicensingSummary initialData) {
            this.generatedOn = initialData.getGeneratedOn();
            this.versionId = initialData.getVersionId();
            this.application = initialData.getApplication();
            this.applicationSubtype = initialData.getApplicationSubtype();
            this.totalUsers = initialData.getTotalUsers();
            this.totalUsersFromLocalCrowd = initialData.getTotalUsersFromLocalCrowd();
            this.active = initialData.isActive();
            this.maximumUserLimit = initialData.getMaximumUserLimit();
            this.totalDirectories = initialData.getTotalDirectories();
        }

        public Builder setGeneratedOn(Date generatedOn) {
            this.generatedOn = generatedOn;
            return this;
        }

        public Builder setVersionId(long versionId) {
            this.versionId = versionId;
            return this;
        }

        public Builder setApplication(Application application) {
            this.application = application;
            return this;
        }

        public Builder setApplicationSubtype(String applicationSubtype) {
            this.applicationSubtype = applicationSubtype;
            return this;
        }

        public Builder setTotalUsers(int totalUsers) {
            this.totalUsers = totalUsers;
            return this;
        }

        public Builder setTotalUsersFromLocalCrowd(int totalUsersFromLocalCrowd) {
            this.totalUsersFromLocalCrowd = totalUsersFromLocalCrowd;
            return this;
        }

        public Builder setActive(boolean active) {
            this.active = active;
            return this;
        }

        public Builder setMaximumUserLimit(int maximumUserLimit) {
            this.maximumUserLimit = maximumUserLimit;
            return this;
        }

        public Builder setTotalDirectories(int totalDirectories) {
            this.totalDirectories = totalDirectories;
            return this;
        }

        public ApplicationLicensingSummary build() {
            return new ApplicationLicensingSummary(generatedOn, versionId, application, applicationSubtype, totalUsers, totalUsersFromLocalCrowd, active, maximumUserLimit, totalDirectories);
        }
    }
}
