package com.atlassian.crowd.manager.sso;

import com.atlassian.crowd.model.sso.SamlConfiguration;

import java.security.cert.X509Certificate;
import java.util.Optional;

/**
 * A service for managing global SAML configuration.
 *
 * @since 3.4.0
 */
public interface CrowdSamlConfigurationService {

    /**
     * @return certificate used to verify signature if found, none otherwise
     */
    Optional<X509Certificate> getCertificateToVerifySignature();

    /**
     * Generates and stores new pair of certificate and private key.
     * After storing them, this pair will be used to sign/verify assertions.
     *
     * @return newly-generated certificate to verify signature
     */
    X509Certificate regenerateCertificateAndPrivateKeyToSign();

    /**
     * @return SAML configuration if found, none otherwise
     */
    Optional<SamlConfiguration> getConfiguration();

    /**
     * @return Identity Providers metadata if found, none otherwise
     */
    Optional<String> getMetadata() throws InvalidGlobalSamlConfigurationException;
}
