package com.atlassian.crowd.manager.rememberme;


import javax.servlet.http.HttpServletRequest;

/**
 * Configuration for Crowd Remember me functionality
 */
public interface CrowdRememberMeConfiguration {

    /**
     * Gets remember me cookie name
     */
    String getCookieName();

    /**
     * Returns max cookie age in ms.
     */
    long getCookieMaxAgeInMillis();

    /**
     * Returns max grace period after a remember-me token has been claimed
     */
    long getGracePeriodInMillis();

    /**
     * Path to be configured in the cookie
     */
    String getCookiePath(HttpServletRequest httpServletRequest);

    /**
     * Is the cookie http only
     */
    boolean isCookieHttpOnly(HttpServletRequest httpServletRequest);

    /**
     * Stores passed configuration
     *
     * @param configuration new configuration
     */
    void saveConfiguration(CrowdSpecificRememberMeSettings configuration);

    /**
     * @return Current Remember Me configuration
     */
    CrowdSpecificRememberMeSettings getConfiguration();
}
