package com.atlassian.crowd.manager.mail;

/**
 * The service for interacting with the mail configuration
 *
 * @since 3.3.0
 */
public interface MailConfigurationService {
    /**
     * @return Mail configuration
     * @since 3.3.0
     */
    MailConfiguration getMailConfiguration();

    /**
     * Saves mail configuration
     *
     * @param mailConfiguration entity with mail configuration.
     * @since 3.3.0
     */
    void saveConfiguration(MailConfiguration mailConfiguration);

    /**
     * @return true if the mail server is fully configured, regardless of the configuration's validity
     */
    boolean isConfigured();
}
