package com.atlassian.crowd.emailchange;

import com.atlassian.crowd.exception.CrowdException;

/**
 * Thrown when user tries to change their e-mail to the same e-mail they already have.
 */
public class SameEmailAddressException extends CrowdException {
    private final String username;
    private final String emailAddress;

    public SameEmailAddressException(String username, String emailAddress) {
        super(String.format("User %s is already using email %s", username, emailAddress));
        this.username = username;
        this.emailAddress = emailAddress;
    }

    public String getEmailAddress() {
        return emailAddress;
    }

    public String getUsername() {
        return username;
    }
}
