package com.atlassian.crowd.audit;

/**
 * Allows to run code with overridden default properties (such as the audit log author or source)
 * @since 3.2.0
 */
public interface AuditLogContext {

    /**
     * Executes the callback on behalf of the specified author
     * @param author author of operations
     * @param callback the actions to perform with the specified author
     * @param <T> Type of result of callback
     * @throws Exception the exception thrown from the callback (if any)
     * @return result of callback
     */
    <T> T withAuditLogAuthor(AuditLogAuthor author, AuditLogContextCallback<T> callback) throws Exception;

    /**
     * Executes the callback using the specified source for the events audited in the callback
     * @param source the source to use when auditing
     * @param callback the actions to perform with the specified source
     * @param <T> Type of result of callback
     * @throws Exception the exception thrown from the callback (if any)
     * @return result of callback
     */
    <T> T withAuditLogSource(AuditLogEventSource source, AuditLogContextCallback<T> callback) throws Exception;
}
