package com.atlassian.crowd.model.licensing;

import com.google.common.base.MoreObjects;

import javax.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class ApplicationLicensedUser {

    private final Long id;
    private final String username;
    @Nullable
    private final Date lastActive;
    @Nullable
    private final String fullName;
    @Nullable
    private final String email;

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    protected ApplicationLicensedUser(Long id, String username, @Nullable Date lastActive, @Nullable String fullName, @Nullable String email) {
        this.id = Objects.requireNonNull(id);
        this.username = Objects.requireNonNull(username);
        this.lastActive = lastActive;
        this.fullName = fullName;
        this.email = email;
    }

    public Long getId() {
        return id;
    }

    public String getUsername() {
        return username;
    }

    public Optional<Date> getLastActive() {
        return Optional.ofNullable(lastActive);
    }

    public Optional<String> getFullName() {
        return Optional.ofNullable(fullName);
    }

    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public static ApplicationLicensedUser.Builder builder() {
        return new ApplicationLicensedUser.Builder();
    }

    public static ApplicationLicensedUser.Builder builder(ApplicationLicensedUser data) {
        return new ApplicationLicensedUser.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ApplicationLicensedUser that = (ApplicationLicensedUser) o;

        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getLastActive(), that.getLastActive()) && Objects.equals(this.getFullName(), that.getFullName()) && Objects.equals(this.getEmail(), that.getEmail());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getUsername(), getLastActive(), getFullName(), getEmail());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("username", getUsername())
                .add("lastActive", getLastActive())
                .add("fullName", getFullName())
                .add("email", getEmail())
                .toString();
    }

    public static final class Builder {

        private Long id;
        private String username;
        private Date lastActive;
        private String fullName;
        private String email;

        private Builder() {
        }

        private Builder(ApplicationLicensedUser initialData) {
            this.id = initialData.getId();
            this.username = initialData.getUsername();
            this.lastActive = initialData.getLastActive().orElse(null);
            this.fullName = initialData.getFullName().orElse(null);
            this.email = initialData.getEmail().orElse(null);
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setLastActive(@Nullable Date lastActive) {
            this.lastActive = lastActive;
            return this;
        }

        public Builder setFullName(@Nullable String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder setEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        public ApplicationLicensedUser build() {
            return new ApplicationLicensedUser(id, username, lastActive, fullName, email);
        }
    }
}
