package com.atlassian.crowd.service;

import java.util.List;

public interface SignupSettingsService {
    /**
     * @return true if notification emails should be sent to admins when a user signs themselves up.
     */
    boolean isEmailSentOnSignUp();

    /**
     * @param notify true if notification emails should be sent to admins when a user signs themselves up, false if not
     */
    void setEmailSentOnSignUp(boolean notify);

    /**
     * @param enabled true if users can sign themselves up
     */
    void setSignupEnabled(boolean enabled);

    /**
     * @return true if users can sign themselves up, false if not
     */
    boolean isSignupEnabled();

    /**
     * Set the domains that user's email address should belong to to be able to sign up.
     *
     * @param allowedDomains list of domains
     */
    void setRestrictedDomains(List<String> allowedDomains);

    /**
     * Returns list of domains. Users with email in those domains are allowed to sign up.
     * Provided domain restricted sign up is enabled.
     *
     * @return list of domains
     */
    List<String> getRestrictedDomains();

    /**
     * Checks if the given email address is allowed to sign up. This will be <tt>true</tt> if:
     *
     * <ul>
     * <li>The email address' domain is in the list of restricted domains, or</li>
     * <li>There are no restricted domains.</li>
     * </ul>
     *
     * This is always <tt>false</tt> if signup is disabled.
     *
     * @param email the email address, which must be valid (a string containing one "@").
     */
    boolean isEmailAllowed(String email);
}
