package com.atlassian.crowd.manager.permission;


import java.util.Collection;

import javax.annotation.Nullable;

import com.atlassian.crowd.model.permission.UserPermission;

/**
 * Check Crowd access permissions for users, eg SYS_ADMIN and ADMIN.
 */
public interface UserPermissionService {
    /**
     * Does the current user have the provided permission.
     *
     * @param permission permission required
     * @return true if the user has permission
     */
    boolean currentUserHasPermission(UserPermission permission);

    /**
     * Does the provided user have the provided permission.
     *
     * @param username   user to check, null for the anonymous user
     * @param permission permission required
     * @return true if the user has permission
     */
    boolean hasPermission(@Nullable String username, UserPermission permission);

    /**
     * Does the provided user have the provided permission when not considering the provided groups.
     *
     * This method is intended to be used to determine if a group is exclusively providing a given permission.
     *
     * @param username       user to check, null for the anonymous user
     * @param permission     permission required
     * @param excludedGroups groups to exclude in permission check, or an empty list otherwise
     * @return true if the user has permission outside of the provided groups
     */
    boolean hasPermissionOutsideOfGroups(@Nullable String username, UserPermission permission, Collection<DirectoryGroup> excludedGroups);
}
