/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.event.EventTokenExpiredException;
import com.atlassian.crowd.event.Events;
import com.atlassian.crowd.event.IncrementalSynchronisationNotAvailableException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.plugin.rest.entity.EventEntityList;
import com.atlassian.crowd.plugin.rest.filter.AuthenticatedApplicationHolder;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class EventsController
extends AbstractResourceController {
    private static final Logger log = LoggerFactory.getLogger(EventsController.class);
    private final ApplicationService applicationService;

    @Inject
    public EventsController(@ComponentImport ApplicationService applicationService, AuthenticatedApplicationHolder authenticatedApplicationHolder) {
        super(authenticatedApplicationHolder);
        this.applicationService = applicationService;
    }

    public EventEntityList getCurrentEventToken() {
        Application application = this.getAuthenticatedApplication();
        try {
            return EventEntityList.fromToken(this.applicationService.getCurrentEventToken(application));
        }
        catch (IncrementalSynchronisationNotAvailableException e) {
            return EventEntityList.synchronisationNotAvailable();
        }
    }

    public EventEntityList getEventsSince(String eventToken, URI baseURI) throws EventTokenExpiredException, OperationFailedException {
        Application application = this.getAuthenticatedApplication();
        try {
            log.debug("Fetching operation events for application {} with token {}", (Object)application, (Object)eventToken);
            Events events = this.applicationService.getNewEvents(application, eventToken);
            return EntityTranslator.toEventEntities(events, baseURI);
        }
        catch (EventTokenExpiredException e) {
            log.debug("Refusing incremental sync for application {} with token {}: {}", new Object[]{application.getName(), eventToken, e.getMessage()});
            throw e;
        }
        catch (Exception e) {
            log.warn("Failed when getting incremental sync events for application {} with token {}", new Object[]{application.getName(), eventToken, e});
            throw e;
        }
    }
}

