/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.cql.parser.CqlQueryParser;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.SearchRestrictionEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.filter.AuthenticatedApplicationHolder;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.SearchRestrictionEntityTranslator;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.PropertyTypeService;
import com.atlassian.crowd.search.query.entity.PropertyTypeServiceImpl;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class SearchController
extends AbstractResourceController {
    private final ApplicationService applicationService;
    private final CqlQueryParser cqlQueryParser;
    private final PropertyTypeService userPropertyTypeService;
    private final PropertyTypeService groupPropertyTypeService;

    @Inject
    public SearchController(@ComponentImport ApplicationService applicationService, @ComponentImport CqlQueryParser cqlQueryParser, AuthenticatedApplicationHolder authenticatedApplicationHolder) {
        super(authenticatedApplicationHolder);
        this.applicationService = applicationService;
        this.cqlQueryParser = cqlQueryParser;
        this.userPropertyTypeService = PropertyTypeServiceImpl.newInstance((Iterable)UserTermKeys.ALL_USER_PROPERTIES);
        this.groupPropertyTypeService = PropertyTypeServiceImpl.newInstance((Iterable)GroupTermKeys.ALL_GROUP_PROPERTIES);
    }

    public GroupEntityList searchGroups(SearchRestrictionEntity searchRestrictionEntity, int maxResults, int startIndex, boolean expandGroup, boolean expandAttributes, URI baseUri) {
        SearchRestriction searchRestriction = SearchRestrictionEntityTranslator.toSearchRestriction(searchRestrictionEntity);
        return this.searchGroups(searchRestriction, maxResults, startIndex, expandGroup, expandAttributes, baseUri);
    }

    public UserEntityList searchUsers(SearchRestrictionEntity searchRestrictionEntity, int maxResults, int startIndex, boolean expandUser, boolean expandAttributes, URI baseUri) {
        SearchRestriction searchRestriction = SearchRestrictionEntityTranslator.toSearchRestriction(searchRestrictionEntity);
        return this.searchUsers(searchRestriction, maxResults, startIndex, expandUser, expandAttributes, baseUri);
    }

    public GroupEntityList searchGroups(String cqlSearchRestriction, int maxResults, int startIndex, boolean expandGroup, boolean expandAttributes, URI baseUri) {
        NullRestriction searchRestriction = StringUtils.isBlank((CharSequence)cqlSearchRestriction) ? NullRestrictionImpl.INSTANCE : this.cqlQueryParser.parseQuery(cqlSearchRestriction, this.groupPropertyTypeService);
        return this.searchGroups((SearchRestriction)searchRestriction, maxResults, startIndex, expandGroup, expandAttributes, baseUri);
    }

    public UserEntityList searchUsers(String cqlSearchRestriction, int maxResults, int startIndex, boolean expandUser, boolean expandAttributes, URI baseUri) {
        NullRestriction searchRestriction = StringUtils.isBlank((CharSequence)cqlSearchRestriction) ? NullRestrictionImpl.INSTANCE : this.cqlQueryParser.parseQuery(cqlSearchRestriction, this.userPropertyTypeService);
        return this.searchUsers((SearchRestriction)searchRestriction, maxResults, startIndex, expandUser, expandAttributes, baseUri);
    }

    private GroupEntityList searchGroups(SearchRestriction searchRestriction, int maxResults, int startIndex, boolean expandGroup, boolean expandAttributes, URI baseUri) {
        Application application = this.getAuthenticatedApplication();
        if (expandGroup) {
            if (expandAttributes) {
                EntityQuery entityQuery = QueryBuilder.queryFor(GroupWithAttributes.class, (EntityDescriptor)EntityDescriptor.group()).with(searchRestriction).startingAt(startIndex).returningAtMost(maxResults);
                List groups = this.applicationService.searchGroups(application, entityQuery);
                return EntityTranslator.toGroupEntities(groups, baseUri);
            }
            EntityQuery entityQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with(searchRestriction).startingAt(startIndex).returningAtMost(maxResults);
            List groups = this.applicationService.searchGroups(application, entityQuery);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        EntityQuery entityQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with(searchRestriction).startingAt(startIndex).returningAtMost(maxResults);
        List groupNames = this.applicationService.searchGroups(application, entityQuery);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    private UserEntityList searchUsers(SearchRestriction searchRestriction, int maxResults, int startIndex, boolean expandUser, boolean expandAttributes, URI baseUri) {
        Application application = this.getAuthenticatedApplication();
        if (expandUser) {
            if (expandAttributes) {
                EntityQuery entityQuery = QueryBuilder.queryFor(UserWithAttributes.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).startingAt(startIndex).returningAtMost(maxResults);
                List users = this.applicationService.searchUsers(application, entityQuery);
                return EntityTranslator.toUserEntities(users, baseUri);
            }
            EntityQuery entityQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).startingAt(startIndex).returningAtMost(maxResults);
            List users = this.applicationService.searchUsers(application, entityQuery);
            return EntityTranslator.toUserEntities(users, baseUri);
        }
        EntityQuery entityQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).startingAt(startIndex).returningAtMost(maxResults);
        List userNames = this.applicationService.searchUsers(application, entityQuery);
        return EntityTranslator.toMinimalUserEntities(userNames, baseUri);
    }
}

