/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;

public class AuthenticationController
extends AbstractResourceController {
    public AuthenticationController(ApplicationService applicationService, ApplicationManager applicationManager) {
        super(applicationService, applicationManager);
    }

    public UserEntity authenticateUser(String applicationName, String username, PasswordEntity password, URI baseUri) throws UserNotFoundException, ExpiredCredentialException, InactiveAccountException, InvalidAuthenticationException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        User user = this.applicationService.authenticateUser(application, username, PasswordCredential.unencrypted((String)password.getValue()));
        if (!this.applicationService.isUserAuthorised(application, username)) {
            throw new InvalidAuthenticationException("User is not allowed to authenticate with the application");
        }
        Link userLink = LinkUriHelper.buildUserLink(baseUri, user.getName());
        UserEntity userEntity = EntityTranslator.toUserEntity(user, userLink);
        return userEntity;
    }
}

