/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;

public class AuthenticatedApplicationUtil {
    public static final String APPLICATION_ATTRIBUTE_KEY = "com.atlassian.crowd.authenticated.application.name";

    private AuthenticatedApplicationUtil() {
    }

    public static String getAuthenticatedApplication(HttpServletRequest request) {
        Validate.notNull((Object)request);
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        Object value = session.getAttribute(APPLICATION_ATTRIBUTE_KEY);
        return value instanceof String ? (String)value : null;
    }

    public static void setAuthenticatedApplication(HttpServletRequest request, String applicationName) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)applicationName);
        request.getSession().setAttribute(APPLICATION_ATTRIBUTE_KEY, (Object)applicationName);
    }
}

