/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.service.controller.UsersController;
import com.atlassian.crowd.plugin.rest.service.resource.AbstractResource;
import com.atlassian.crowd.plugin.rest.util.EntityExpansionUtil;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.net.URI;
import java.util.ConcurrentModificationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

@Path(value="user")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@AnonymousAllowed
public class UsersResource
extends AbstractResource {
    private static final String USER_NAME_QUERY_PARAM = "username";
    private static final String USER_NAME_NULL_ERROR_MSG = "username query parameter must be given";
    private static final String EMAIL_QUERY_PARAM = "email";
    private static final String EMAIL_NULL_ERROR_MSG = "email query parameter must be given";
    private final UsersController usersController;

    public UsersResource(UsersController usersController) {
        this.usersController = usersController;
    }

    @GET
    public Response getUser(@QueryParam(value="username") String userName) throws UserNotFoundException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        Link userLink = LinkUriHelper.buildUserLink(this.uriInfo.getBaseUri(), userName);
        UserEntity userEntity = this.usersController.findUserByName(applicationName, userName, userLink, this.expandAttributes());
        return Response.ok((Object)userEntity).build();
    }

    @POST
    public Response addUser(UserEntity userEntity) throws InvalidUserException, InvalidCredentialException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userEntity);
        Validate.notNull((Object)userEntity.getName());
        Validate.notNull((Object)userEntity.getPassword());
        Validate.notNull((Object)userEntity.getPassword().getValue());
        String canonicalUsername = this.usersController.addUser(applicationName, userEntity);
        URI userUri = LinkUriHelper.buildUserUri(this.uriInfo.getBaseUri(), canonicalUsername);
        return Response.created((URI)userUri).build();
    }

    @PUT
    public Response updateUser(@QueryParam(value="username") String userName, UserEntity userEntity) throws InvalidUserException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        if (!StringUtils.equalsIgnoreCase((String)userName, (String)userEntity.getName())) {
            throw new IllegalArgumentException("The names of the resource location <" + this.uriInfo.getPath() + "> and object <" + userEntity.getName() + "> are not equal");
        }
        this.usersController.updateUser(applicationName, userEntity);
        return Response.noContent().build();
    }

    @DELETE
    public Response removeUser(@QueryParam(value="username") String userName) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        this.usersController.removeUser(applicationName, userName);
        return Response.noContent().build();
    }

    @GET
    @Path(value="attribute")
    public Response getUserAttributes(@QueryParam(value="username") String userName) throws UserNotFoundException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        Link userLink = LinkUriHelper.buildUserLink(this.uriInfo.getBaseUri(), userName);
        UserEntity userEntity = this.usersController.findUserByName(applicationName, userName, userLink, true);
        return Response.ok((Object)userEntity.getAttributes()).build();
    }

    @POST
    @Path(value="attribute")
    public Response storeUserAttributes(@QueryParam(value="username") String userName, MultiValuedAttributeEntityList attributes) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        this.usersController.storeUserAttributes(applicationName, userName, attributes);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="attribute")
    public Response removeUserAttribute(@QueryParam(value="username") String userName, @QueryParam(value="attributename") String attributeName) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        Validate.notNull((Object)attributeName, (String)"attributename query parameter must be given");
        this.usersController.removeUserAttribute(applicationName, userName, attributeName);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="password")
    public Response updateUserPassword(@QueryParam(value="username") String userName, PasswordEntity password) throws InvalidCredentialException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        this.usersController.updateUserPassword(applicationName, userName, password.getValue());
        return Response.noContent().build();
    }

    @POST
    @Path(value="mail/password")
    public Response requestPasswordReset(@QueryParam(value="username") String userName) throws InvalidEmailAddressException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        try {
            this.usersController.requestPasswordReset(applicationName, userName);
        }
        catch (ApplicationNotFoundException e) {
            throw new ConcurrentModificationException("Application removed while requesting password reset");
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="mail/usernames")
    public Response requestUsernames(@QueryParam(value="email") String email) throws InvalidEmailAddressException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)email, (String)EMAIL_NULL_ERROR_MSG);
        try {
            this.usersController.requestUsernames(applicationName, email);
        }
        catch (ApplicationNotFoundException e) {
            throw new ConcurrentModificationException("Application removed while requesting usernames");
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="group/direct")
    public Response getDirectGroups(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex) throws MembershipNotFoundException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        if (StringUtils.isEmpty((String)groupName)) {
            GroupEntityList directGroups = this.usersController.getDirectGroups(applicationName, userName, this.expandGroups(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)directGroups).build();
        }
        GroupEntity directGroup = this.usersController.getDirectGroup(applicationName, userName, groupName, this.getBaseUri());
        return Response.ok((Object)directGroup).build();
    }

    @POST
    @Path(value="group/direct")
    public Response addUserToGroup(@QueryParam(value="username") String userName, GroupEntity parentGroup) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        try {
            this.usersController.addUserToGroup(applicationName, userName, parentGroup.getName());
            return Response.created((URI)LinkUriHelper.buildDirectParentGroupOfUserUri(this.getBaseUri(), userName, parentGroup.getName())).build();
        }
        catch (GroupNotFoundException e) {
            ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of((Exception)((Object)e)), e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorEntity).build();
        }
    }

    @DELETE
    @Path(value="group/direct")
    public Response removeUserFromGroup(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName) throws GroupNotFoundException, MembershipNotFoundException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        this.usersController.removeUserFromGroup(this.getApplicationName(), userName, groupName);
        return Response.noContent().build();
    }

    @GET
    @Path(value="group/nested")
    public Response getNestedGroups(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex) throws MembershipNotFoundException {
        String applicationName = this.getApplicationName();
        Validate.notNull((Object)userName, (String)USER_NAME_NULL_ERROR_MSG);
        if (StringUtils.isEmpty((String)groupName)) {
            GroupEntityList directGroups = this.usersController.getNestedGroups(applicationName, userName, this.expandGroups(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)directGroups).build();
        }
        GroupEntity directGroup = this.usersController.getNestedGroup(applicationName, userName, groupName, this.getBaseUri());
        return Response.ok((Object)directGroup).build();
    }

    private boolean expandAttributes() {
        return EntityExpansionUtil.shouldExpandField(UserEntity.class, "attributes", this.request);
    }

    private boolean expandGroups() {
        return EntityExpansionUtil.shouldExpandField(GroupEntityList.class, "groups", this.request);
    }
}

