/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.GroupEntityUtil;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupsController
extends AbstractResourceController {
    public GroupsController(ApplicationService applicationService, ApplicationManager applicationManager) {
        super(applicationService, applicationManager);
    }

    public GroupEntity findGroupByName(String applicationName, String name, boolean expandAttributes, URI baseURI) throws GroupNotFoundException {
        Application application = this.getApplication(applicationName);
        GroupEntity minimalGroup = GroupEntity.newMinimalGroupEntity(name, applicationName, baseURI);
        return GroupEntityUtil.expandGroup(this.applicationService, application, minimalGroup, expandAttributes);
    }

    private GroupEntity findGroupWithAttributesByName(String applicationName, String name, URI baseURI) throws GroupNotFoundException {
        Application application = this.getApplication(applicationName);
        GroupWithAttributes group = this.applicationService.findGroupWithAttributesByName(application, name);
        return EntityTranslator.toGroupEntity((Group)group, (Attributes)group, LinkUriHelper.buildGroupLink(baseURI, group.getName()));
    }

    public String addGroup(String applicationName, GroupEntity group) throws ApplicationPermissionException, OperationFailedException, InvalidGroupException, GroupNotFoundException {
        Application application = this.getApplication(applicationName);
        return this.applicationService.addGroup(application, EntityTranslator.toGroup(group)).getName();
    }

    public GroupEntity updateGroup(String applicationName, GroupEntity group, URI baseURI) throws ApplicationPermissionException, OperationFailedException, InvalidGroupException, GroupNotFoundException {
        Application application = this.getApplication(applicationName);
        Group updatedGroup = this.applicationService.updateGroup(application, EntityTranslator.toGroup(group));
        return EntityTranslator.toGroupEntity(updatedGroup, baseURI);
    }

    public void removeGroup(String applicationName, String groupName) throws ApplicationPermissionException, OperationFailedException, GroupNotFoundException {
        Application application = this.getApplication(applicationName);
        this.applicationService.removeGroup(application, groupName);
    }

    public void storeGroupAttributes(String applicationName, String groupName, MultiValuedAttributeEntityList attributes) throws ApplicationPermissionException, OperationFailedException, GroupNotFoundException {
        Application application = this.getApplication(applicationName);
        if (attributes != null && !attributes.isEmpty()) {
            Map<String, Set<String>> groupAttributes = EntityTranslator.toAttributes(attributes);
            this.applicationService.storeGroupAttributes(application, groupName, groupAttributes);
        }
    }

    public void removeGroupAttributes(String applicationName, String groupName, String attributeName) throws ApplicationPermissionException, OperationFailedException, GroupNotFoundException {
        Application application = this.getApplication(applicationName);
        this.applicationService.removeGroupAttributes(application, groupName, attributeName);
    }

    public UserEntityList getDirectUsers(String applicationName, String groupName, boolean expandUsers, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getApplication(applicationName);
        if (expandUsers) {
            MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
            List users = this.applicationService.searchDirectGroupRelationships(application, query);
            return EntityTranslator.toUserEntities(users, baseUri);
        }
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        List usernames = this.applicationService.searchDirectGroupRelationships(application, query);
        return EntityTranslator.toMinimalUserEntities(usernames, baseUri);
    }

    public void addDirectUser(String applicationName, String groupName, String username) throws ApplicationPermissionException, UserNotFoundException, GroupNotFoundException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.addUserToGroup(application, username, groupName);
    }

    public UserEntity getDirectUser(String applicationName, String groupName, String username, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getApplication(applicationName);
        boolean isMember = this.applicationService.isUserDirectGroupMember(application, username, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(username, groupName);
        }
        return UserEntity.newMinimalUserEntity(username, null, LinkUriHelper.buildUserLink(baseUri, username));
    }

    public void deleteDirectUser(String applicationName, String groupName, String username) throws ApplicationPermissionException, MembershipNotFoundException, UserNotFoundException, GroupNotFoundException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.removeUserFromGroup(application, username, groupName);
    }

    public UserEntityList getNestedUsers(String applicationName, String groupName, boolean expandUsers, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getApplication(applicationName);
        if (expandUsers) {
            MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
            List users = this.applicationService.searchNestedGroupRelationships(application, query);
            return EntityTranslator.toUserEntities(users, baseUri);
        }
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        List usernames = this.applicationService.searchNestedGroupRelationships(application, query);
        return EntityTranslator.toMinimalUserEntities(usernames, baseUri);
    }

    public UserEntity getNestedUser(String applicationName, String groupName, String username, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getApplication(applicationName);
        boolean isMember = this.applicationService.isUserNestedGroupMember(application, username, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(username, groupName);
        }
        return UserEntity.newMinimalUserEntity(username, null, LinkUriHelper.buildUserLink(baseUri, username));
    }

    public GroupEntityList getDirectParentGroups(String applicationName, String groupName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getApplication(applicationName);
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
            List groups = this.applicationService.searchDirectGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        List groupNames = this.applicationService.searchDirectGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public void addDirectParentGroup(String applicationName, String groupName, String parentGroupName) throws ApplicationPermissionException, InvalidMembershipException, GroupNotFoundException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.addGroupToGroup(application, groupName, parentGroupName);
    }

    public GroupEntity getDirectParentGroup(String applicationName, String groupName, String parentGroupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getApplication(applicationName);
        boolean isMember = this.applicationService.isGroupDirectGroupMember(application, groupName, parentGroupName);
        if (!isMember) {
            throw new MembershipNotFoundException(groupName, parentGroupName);
        }
        return GroupEntity.newMinimalGroupEntity(parentGroupName, null, baseUri);
    }

    public GroupEntityList getNestedParentGroups(String applicationName, String groupName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getApplication(applicationName);
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
            List groups = this.applicationService.searchNestedGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        List groupNames = this.applicationService.searchNestedGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public GroupEntity getNestedParentGroup(String applicationName, String groupName, String parentGroupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getApplication(applicationName);
        boolean isMember = this.applicationService.isGroupNestedGroupMember(application, groupName, parentGroupName);
        if (!isMember) {
            throw new MembershipNotFoundException(groupName, parentGroupName);
        }
        return GroupEntity.newMinimalGroupEntity(parentGroupName, null, baseUri);
    }

    public GroupEntityList getDirectChildGroups(String applicationName, String groupName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getApplication(applicationName);
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), Group.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
            List groups = this.applicationService.searchDirectGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
        List groupNames = this.applicationService.searchDirectGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public void addDirectChildGroup(String applicationName, String groupName, String childGroupName) throws ApplicationPermissionException, InvalidMembershipException, GroupNotFoundException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.addGroupToGroup(application, childGroupName, groupName);
    }

    public GroupEntity getDirectChildGroup(String applicationName, String groupName, String childGroupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getApplication(applicationName);
        boolean isMember = this.applicationService.isGroupDirectGroupMember(application, childGroupName, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(childGroupName, groupName);
        }
        return GroupEntity.newMinimalGroupEntity(childGroupName, null, baseUri);
    }

    public void deleteDirectChildGroup(String applicationName, String groupName, String childGroupName) throws ApplicationPermissionException, MembershipNotFoundException, GroupNotFoundException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.removeGroupFromGroup(application, childGroupName, groupName);
    }

    public GroupEntityList getNestedChildGroups(String applicationName, String groupName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getApplication(applicationName);
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), Group.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
            List groups = this.applicationService.searchNestedGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
        List groupNames = this.applicationService.searchNestedGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public GroupEntity getNestedChildGroup(String applicationName, String groupName, String childGroupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getApplication(applicationName);
        boolean isMember = this.applicationService.isGroupNestedGroupMember(application, childGroupName, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(childGroupName, groupName);
        }
        return GroupEntity.newMinimalGroupEntity(childGroupName, null, baseUri);
    }
}

