/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SpringComponentModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(SpringComponentModuleDescriptor.class);
    String alias;
    private Document document;
    private ApplicationContext applicationContext;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.alias = element.attributeValue("alias");
        if (StringUtils.isBlank((String)this.alias)) {
            this.alias = this.getKey();
        }
        DocumentFactory factory = DocumentFactory.getInstance();
        Element beans = factory.createElement("beans");
        Element bean = factory.createElement("bean");
        beans.add(bean);
        bean.addAttribute("id", this.alias);
        bean.addAttribute("class", this.getModuleClass().getName());
        for (Attribute a : element.attributes()) {
            if (a.getName().equals("key") || a.getName().equals("name") || a.getName().equals("class") || a.getName().equals("alias")) continue;
            bean.addAttribute(a.getName(), a.getValue());
        }
        for (int i = 0; i < element.nodeCount(); ++i) {
            if (!(element.node(i) instanceof Element)) continue;
            bean.add(((Element)element.node(i)).createCopy());
        }
        this.document = factory.createDocument();
        this.document.add(beans);
    }

    public Object getModule() {
        return this.applicationContext.getAutowireCapableBeanFactory().getBean(this.alias);
    }

    public void enabled() {
        super.enabled();
        DefaultListableBeanFactory beanFactory = this.getGlobalBeanFactory();
        if (beanFactory != null) {
            boolean definitionExists;
            try {
                definitionExists = beanFactory.getBeanDefinition(this.alias) != null;
            }
            catch (NoSuchBeanDefinitionException e) {
                definitionExists = false;
            }
            if (definitionExists) {
                throw new IllegalStateException("Can not overwrite an existing bean definition: " + this.alias);
            }
            log.debug((Object)("Creating bean definition for " + this.alias + " with class " + this.getModuleClass().getName()));
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
            if (this.plugin.isDynamicallyLoaded()) {
                reader.setBeanClassLoader(this.plugin.getClassLoader());
            }
            DOMWriter writer = new DOMWriter();
            try {
                reader.registerBeanDefinitions(writer.write(this.document), (Resource)new ClassPathResource("x"));
                this.applicationContext.getBean(this.alias);
            }
            catch (DocumentException de) {
                log.error((Object)"failed to convert Document to DOM", (Throwable)de);
            }
        }
    }

    public void disabled() {
        DefaultListableBeanFactory beanFactory = this.getGlobalBeanFactory();
        if (beanFactory != null) {
            log.debug((Object)("Removing bean definition for " + this.alias));
            this.unregisterBeanDefinition(this.alias);
        }
        super.disabled();
    }

    public void unregisterBeanDefinition(String beanAlias) {
        this.getGlobalBeanFactory().removeBeanDefinition(beanAlias);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private DefaultListableBeanFactory getGlobalBeanFactory() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
            if (configurableApplicationContext.getBeanFactory() instanceof DefaultListableBeanFactory) {
                return (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
            }
            log.error((Object)"Failed to lookup global bean factory - BeanFactory was not a DefaultListableBeanFactory?");
        } else {
            log.error((Object)"Failed to lookup global bean factory - ApplicationContext was not a ConfigurableApplicationContext?");
        }
        return null;
    }
}

