/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.crypto;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.directory.ImmutableDirectory;
import java.util.HashMap;
import java.util.function.UnaryOperator;

public class DirectoryPasswordsEncryptor {
    private final Encryptor encryptor;

    public DirectoryPasswordsEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public Directory decryptPasswords(Directory directory) {
        return this.transformPasswordAttributes(directory, arg_0 -> ((Encryptor)this.encryptor).decrypt(arg_0));
    }

    public Directory encryptPasswords(Directory directory) {
        return this.transformPasswordAttributes(directory, arg_0 -> ((Encryptor)this.encryptor).encrypt(arg_0));
    }

    private Directory transformPasswordAttributes(Directory directory, UnaryOperator<String> transformer) {
        HashMap<String, String> transformedAttributes = new HashMap<String, String>(directory.getAttributes());
        transformedAttributes.replaceAll((k, v) -> v != null && DirectoryImpl.PASSWORD_ATTRIBUTES.contains(k) ? (String)transformer.apply((String)v) : v);
        return new ImmutableDirectory.Builder(directory).setAttributes(transformedAttributes).build();
    }
}

