/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.AbstractInternalDirectory;
import com.atlassian.crowd.directory.InternalDirectoryUtils;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.UserUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalDirectory
extends AbstractInternalDirectory {
    private static final Logger logger = LoggerFactory.getLogger(InternalDirectory.class);

    public InternalDirectory(InternalDirectoryUtils internalDirectoryUtils, PasswordEncoderFactory passwordEncoderFactory, DirectoryDao directoryDao, UserDao userDao, GroupDao groupDao, MembershipDao membershipDao) {
        super(internalDirectoryUtils, passwordEncoderFactory, directoryDao, userDao, groupDao, membershipDao);
    }

    @Override
    public com.atlassian.crowd.model.user.User addUser(UserTemplate user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        com.atlassian.crowd.model.user.User addedUser;
        this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)user, this.directoryId);
        this.internalDirectoryUtils.validateUsername(user.getName());
        com.atlassian.crowd.model.user.User prepopulatedUser = UserUtils.populateNames((com.atlassian.crowd.model.user.User)user);
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
        if (credential != null) {
            this.prepareUserCredentialForAdd(credential, attributes);
        }
        try {
            addedUser = this.userDao.add(prepopulatedUser, credential);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        try {
            this.userDao.storeAttributes(addedUser, attributes);
        }
        catch (UserNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        return addedUser;
    }

    void prepareUserCredentialForAdd(PasswordCredential credential, Map<String, Set<String>> attributes) throws InvalidCredentialException {
        this.internalDirectoryUtils.validateCredential(credential, this.getValue("password_regex"));
        attributes.put("passwordLastChanged", Collections.singleton(Long.toString(System.currentTimeMillis())));
        attributes.put("requiresPasswordChange", Collections.singleton(Boolean.FALSE.toString()));
        this.encryptCredential(credential);
    }

    @Override
    public Group addLocalGroup(GroupTemplate group) throws OperationFailedException {
        throw new OperationNotSupportedException("addLocalGroup() is not supported for InternalDirectory");
    }

    public BatchResult<com.atlassian.crowd.model.user.User> addAllUsers(Set<UserTemplateWithCredentialAndAttributes> users) {
        Validate.notNull(users, (String)"users cannot be null");
        HashSet<UserTemplateWithCredentialAndAttributes> preparedUsers = new HashSet<UserTemplateWithCredentialAndAttributes>();
        ArrayList<UserTemplateWithCredentialAndAttributes> failedUsers = new ArrayList<UserTemplateWithCredentialAndAttributes>();
        for (UserTemplateWithCredentialAndAttributes uncleansedUser : users) {
            com.atlassian.crowd.model.user.User prepopulatedUser = UserUtils.populateNames((com.atlassian.crowd.model.user.User)uncleansedUser);
            UserTemplateWithCredentialAndAttributes user = new UserTemplateWithCredentialAndAttributes(prepopulatedUser, uncleansedUser.getAttributes(), uncleansedUser.getCredential());
            try {
                this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)user, this.getDirectoryId());
                this.internalDirectoryUtils.validateUsername(user.getName());
                this.prepareUserCredentialForAdd(user.getCredential(), user.getAttributes());
                preparedUsers.add(user);
            }
            catch (IllegalArgumentException e) {
                if (uncleansedUser == null) {
                    throw new IllegalArgumentException("Cannot add null user. " + e);
                }
                failedUsers.add(user);
                logger.error("Cannot add invalid user " + uncleansedUser.getName(), (Throwable)e);
            }
            catch (InvalidCredentialException e) {
                failedUsers.add(uncleansedUser);
                logger.error("Cannot add user with invalid password " + uncleansedUser.getName(), (Throwable)e);
            }
        }
        BatchResult result = this.userDao.addAll(preparedUsers);
        result.addFailures(failedUsers);
        return result;
    }

    public BatchResult<Group> addAllGroups(Set<GroupTemplate> groups) {
        Validate.notNull(groups, (String)"groups cannot be null");
        HashSet<GroupTemplate> preparedGroups = new HashSet<GroupTemplate>();
        ArrayList<GroupTemplate> failedGroups = new ArrayList<GroupTemplate>();
        for (GroupTemplate group : groups) {
            try {
                this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)group, this.getDirectoryId());
                this.internalDirectoryUtils.validateGroupName((Group)group, group.getName());
                preparedGroups.add(group);
            }
            catch (IllegalArgumentException e) {
                if (group == null) {
                    throw new IllegalArgumentException("Cannot add null group. " + e);
                }
                failedGroups.add(group);
                logger.error("Cannot add invalid group " + group.getName(), (Throwable)e);
            }
        }
        try {
            BatchResult result = this.groupDao.addAll(preparedGroups);
            result.addFailures(failedGroups);
            return result;
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public BatchResult<String> addAllUsersToGroup(Set<String> userNames, String groupName) throws GroupNotFoundException {
        Validate.notNull(userNames, (String)"userNames cannot be null");
        Validate.notEmpty((String)groupName, (String)"groupName cannot be null or empty");
        return this.membershipDao.addAllUsersToGroup(this.getDirectoryId(), userNames, groupName);
    }
}

