/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.hibernate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HQLQuery {
    protected final StringBuilder select = new StringBuilder("");
    protected final StringBuilder from = new StringBuilder(" FROM ");
    protected final StringBuilder where = new StringBuilder(" WHERE ");
    protected final StringBuilder orderBy = new StringBuilder(" ORDER BY ");
    protected int aliasCounter = 0;
    protected boolean distinctRequired = false;
    protected boolean whereRequired = false;
    protected boolean orderByRequired = false;
    private final List<Object> parameterValues = new ArrayList<Object>();

    public StringBuilder appendSelect(CharSequence hql) {
        this.select.append(hql);
        return this.select;
    }

    public StringBuilder appendFrom(CharSequence hql) {
        this.from.append(hql);
        return this.from;
    }

    public StringBuilder appendWhere(CharSequence hql) {
        this.whereRequired = true;
        this.where.append(hql);
        return this.where;
    }

    public StringBuilder appendOrderBy(CharSequence hql) {
        this.orderByRequired = true;
        this.orderBy.append(hql);
        return this.orderBy;
    }

    public StringBuilder getNextAlias(String baseAliasName) {
        ++this.aliasCounter;
        return new StringBuilder(baseAliasName).append(this.aliasCounter);
    }

    public void addParameterValue(Object value) {
        this.parameterValues.add(value);
    }

    public List<Object> getParameterValues() {
        return Collections.unmodifiableList(this.parameterValues);
    }

    public void requireDistinct() {
        this.distinctRequired = true;
    }

    public String toString() {
        StringBuilder hql = new StringBuilder("SELECT ");
        if (this.distinctRequired) {
            hql.append("DISTINCT ");
        }
        hql.append((CharSequence)this.select);
        hql.append((CharSequence)this.from);
        if (this.whereRequired) {
            hql.append((CharSequence)this.where);
        }
        if (this.orderByRequired) {
            hql.append((CharSequence)this.orderBy);
        }
        return hql.toString();
    }
}

