/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.loader;

import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.CachingDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DelegatedAuthenticationDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.InternalDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.LDAPDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.event.api.EventPublisher;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedAuthenticationDirectoryInstanceLoaderImpl
extends CachingDirectoryInstanceLoader
implements DelegatedAuthenticationDirectoryInstanceLoader {
    private final DirectoryInstanceLoader ldapDirectoryInstanceLoader;
    private final DirectoryInstanceLoader internalDirectoryInstanceLoader;
    private final DirectoryDao directoryDao;

    public DelegatedAuthenticationDirectoryInstanceLoaderImpl(LDAPDirectoryInstanceLoader ldapDirectoryInstanceLoader, InternalDirectoryInstanceLoader internalDirectoryInstanceLoader, EventPublisher eventPublisher, DirectoryDao directoryDao) {
        super(eventPublisher);
        this.ldapDirectoryInstanceLoader = ldapDirectoryInstanceLoader;
        this.internalDirectoryInstanceLoader = internalDirectoryInstanceLoader;
        this.directoryDao = directoryDao;
    }

    @Override
    protected RemoteDirectory getNewDirectory(Directory directory) throws DirectoryInstantiationException {
        RemoteDirectory ldapDirectory = this.ldapDirectoryInstanceLoader.getDirectory(this.getLdapVersionOfDirectory(directory));
        RemoteDirectory internalDirectory = this.internalDirectoryInstanceLoader.getDirectory(this.getInternalVersionOfDirectory(directory));
        return new DelegatedAuthenticationDirectory(ldapDirectory, internalDirectory, this.getEventPublisher(), this.directoryDao);
    }

    private Directory getLdapVersionOfDirectory(Directory directory) {
        DirectoryImpl ldap = new DirectoryImpl(directory);
        String ldapClass = directory.getValue("crowd.delegated.directory.type");
        ldap.setImplementationClass(ldapClass);
        return ldap;
    }

    private Directory getInternalVersionOfDirectory(Directory directory) {
        DirectoryImpl internal = new DirectoryImpl(directory);
        internal.setImplementationClass(InternalDirectory.class.getCanonicalName());
        HashMap<String, String> newAttributes = new HashMap<String, String>(internal.getAttributes());
        newAttributes.put("user_encryption_method", "sha");
        internal.setAttributes(newAttributes);
        return internal;
    }

    public RemoteDirectory getRawDirectory(Long id, String className, Map<String, String> attributes) throws DirectoryInstantiationException {
        String ldapClass = attributes.get("crowd.delegated.directory.type");
        RemoteDirectory ldapDirectory = this.ldapDirectoryInstanceLoader.getRawDirectory(id, ldapClass, attributes);
        RemoteDirectory internalDirectory = this.internalDirectoryInstanceLoader.getRawDirectory(id, InternalDirectory.class.getCanonicalName(), attributes);
        return new DelegatedAuthenticationDirectory(ldapDirectory, internalDirectory, this.getEventPublisher(), this.directoryDao);
    }

    public boolean canLoad(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return DelegatedAuthenticationDirectory.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

