/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.token.ResetPasswordTokenDao;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.CacheManagerException;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.model.token.ResetPasswordToken;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class ResetPasswordTokenDaoMemory
implements ResetPasswordTokenDao {
    private static final Logger logger = Logger.getLogger(ResetPasswordTokenDaoMemory.class);
    public static final String CACHE_NAME = ResetPasswordToken.class.getName();
    private final CacheManager cacheManager;

    public ResetPasswordTokenDaoMemory(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public ResetPasswordToken addToken(ResetPasswordToken token) {
        try {
            this.cacheManager.put(CACHE_NAME, (Serializable)((Object)token.getUsername()), (Serializable)token);
        }
        catch (CacheManagerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return token;
    }

    public ResetPasswordToken findTokenByUsername(String username) throws ObjectNotFoundException {
        try {
            return (ResetPasswordToken)this.cacheManager.get(CACHE_NAME, (Serializable)((Object)username));
        }
        catch (NotInCacheException e) {
            throw new ObjectNotFoundException(ResetPasswordToken.class, (Object)username);
        }
    }

    public void removeTokenByUsername(String username) {
        this.cacheManager.remove(CACHE_NAME, (Serializable)((Object)username));
    }
}

