/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch.hibernate3;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.util.persistence.hibernate.batch.AbstractBatchFinder;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hibernate3BatchFinder
extends AbstractBatchFinder {
    private static final Logger logger = LoggerFactory.getLogger(Hibernate3BatchFinder.class);
    private static ThreadLocal<Session> currentSessionHolder = new ThreadLocal();
    private final SessionFactory sessionFactory;

    public Hibernate3BatchFinder(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    protected void beforeFind() {
        currentSessionHolder.set(this.sessionFactory.openSession());
    }

    @Override
    protected void afterFind() {
        currentSessionHolder.get().close();
        currentSessionHolder.set(null);
    }

    @Override
    protected <E> Collection<E> processBatchFind(long directoryID, Collection<String> names, Class<E> persistentClass) {
        Collection lowercaseNames = Collections2.transform(names, (Function)new Function<String, String>(){

            public String apply(String from) {
                return IdentifierUtils.toLowerCase((String)from);
            }
        });
        return CriteriaFactory.createCriteria((org.hibernate.Session)currentSessionHolder.get(), persistentClass).add((Criterion)Restrictions.eq((String)"directory.id", (Object)directoryID)).add(Restrictions.in((String)"lowerName", (Collection)lowercaseNames)).list();
    }
}

