/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Logger;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.EhCache;
import org.hibernate.cache.Timestamper;
import org.hibernate.util.ConfigHelper;

public class EhCacheProvider
implements CacheProvider {
    private final CacheManager cacheManager;
    private static final Logger log = Logger.getLogger(EhCacheProvider.class);

    public EhCacheProvider(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Cache buildCache(String name, Properties properties) throws org.hibernate.cache.CacheException {
        try {
            net.sf.ehcache.Cache cache = this.cacheManager.getCache(name);
            if (cache == null) {
                log.warn((Object)("Could not find configuration [" + name + "]; using defaults."));
                this.cacheManager.addCache(name);
                cache = this.cacheManager.getCache(name);
                log.debug((Object)("started EHCache region: " + name));
            }
            return new EhCache(cache);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws org.hibernate.cache.CacheException {
    }

    private URL loadResource(String configurationResourceName) {
        URL url = ConfigHelper.locateConfig((String)configurationResourceName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating EhCacheProvider from a specified resource: " + configurationResourceName + " Resolved to URL: " + url));
        }
        return url;
    }

    public void stop() {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

