/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.util.SOAPPrincipalHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class CrowdUserDetails
implements UserDetails {
    private final SOAPPrincipal principal;
    private final Collection<GrantedAuthority> authorities;
    private static final Set<String> PRIMARY_USER_ATTRIBUTES = ImmutableSet.of((Object)"givenName", (Object)"sn", (Object)"displayName", (Object)"username", (Object)"mail");

    public CrowdUserDetails(SOAPPrincipal principal, GrantedAuthority[] authorities) {
        this(principal, Arrays.asList(authorities));
    }

    public CrowdUserDetails(SOAPPrincipal principal, Collection<GrantedAuthority> authorities) {
        this.principal = principal;
        this.authorities = authorities;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public UserWithAttributes getRemotePrincipal() {
        return new UserWithAttributesAdapter(this.principal, CrowdUserDetails.buildUserAttributeMap(this.principal));
    }

    public String getPassword() {
        throw new UnsupportedOperationException("Not giving you the password");
    }

    public String getUsername() {
        return this.principal.getName();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.principal.isActive();
    }

    public String getFirstName() {
        return this.getFirstAttributeValue("givenName", this.principal);
    }

    public String getLastName() {
        return this.getFirstAttributeValue("sn", this.principal);
    }

    public String getEmail() {
        return this.getFirstAttributeValue("mail", this.principal);
    }

    public String getAttribute(String attributeName) {
        return this.getFirstAttributeValue(attributeName, this.principal);
    }

    public String getFullName() {
        return this.getFirstAttributeValue("displayName", this.principal);
    }

    private String getFirstAttributeValue(String name, SOAPPrincipal principal) {
        SOAPAttribute attribute = this.getAttribute(name, principal);
        if (attribute != null && attribute.getValues() != null && attribute.getValues().length > 0) {
            return attribute.getValues()[0];
        }
        return null;
    }

    private SOAPAttribute getAttribute(String name, SOAPPrincipal principal) {
        SOAPAttribute[] attributes = principal.getAttributes();
        if (attributes != null) {
            for (SOAPAttribute attribute : attributes) {
                if (!attribute.getName().equals(name)) continue;
                return attribute;
            }
        }
        return null;
    }

    private static Map<String, Set<String>> buildUserAttributeMap(SOAPPrincipal soapUser) {
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
        if (soapUser.getAttributes() != null) {
            for (int i = 0; i < soapUser.getAttributes().length; ++i) {
                SOAPAttribute soapAttribute = soapUser.getAttributes()[i];
                if (PRIMARY_USER_ATTRIBUTES.contains(soapAttribute.getName())) continue;
                attributes.put(soapAttribute.getName(), Sets.newHashSet((Object[])soapAttribute.getValues()));
            }
        }
        return attributes;
    }

    private static class UserWithAttributesAdapter
    implements UserWithAttributes {
        private final SOAPPrincipal principal;
        private final Map<String, Set<String>> attributes;
        private final SOAPPrincipalHelper helper;

        public UserWithAttributesAdapter(SOAPPrincipal principal, Map<String, Set<String>> attributes) {
            this.principal = principal;
            this.attributes = attributes;
            this.helper = new SOAPPrincipalHelper();
        }

        public Set<String> getValues(String key) {
            return this.attributes.get(key);
        }

        public String getValue(String key) {
            return this.attributes.containsKey(key) ? this.attributes.get(key).iterator().next() : null;
        }

        public Set<String> getKeys() {
            return this.attributes.keySet();
        }

        public boolean isEmpty() {
            return this.attributes.isEmpty();
        }

        public String getFirstName() {
            return this.helper.getFirstName(this.principal);
        }

        public String getLastName() {
            return this.helper.getLastName(this.principal);
        }

        public String getExternalId() {
            return null;
        }

        public long getDirectoryId() {
            return this.principal.getDirectoryId();
        }

        public boolean isActive() {
            return this.principal.isActive();
        }

        public String getEmailAddress() {
            return this.helper.getEmail(this.principal);
        }

        public String getDisplayName() {
            return this.helper.getFullName(this.principal);
        }

        public int compareTo(User user) {
            return UserComparator.compareTo((User)this, (User)user);
        }

        public String getName() {
            return this.principal.getName();
        }
    }
}

