/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class CrowdSSOAuthenticationToken
extends AbstractAuthenticationToken {
    private static final String UNAUTHENTICATED_TOKEN_PRINCIPAL = "CROWD.SSO";
    private Object credentials;
    private Object principal;

    public CrowdSSOAuthenticationToken(String ssoToken) {
        super(null);
        this.credentials = ssoToken;
        this.principal = UNAUTHENTICATED_TOKEN_PRINCIPAL;
        this.setAuthenticated(false);
    }

    public CrowdSSOAuthenticationToken(CrowdUserDetails principal, String ssoToken, GrantedAuthority[] authorities) {
        this(principal, ssoToken, Arrays.asList(authorities));
    }

    public CrowdSSOAuthenticationToken(CrowdUserDetails principal, String ssoToken, Collection<GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.credentials = ssoToken;
        super.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        if (isAuthenticated) {
            throw new IllegalArgumentException("Cannot set this token to trusted - use constructor containing GrantedAuthority[]s instead");
        }
        super.setAuthenticated(false);
    }
}

