/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.osuser.SOAPPrincipalHelper;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.util.Assert;
import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.PropertyException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class CrowdPropertySet
extends AbstractPropertySet {
    private static final Logger logger = Logger.getLogger(CrowdPropertySet.class);
    private Map keys;
    private SOAPPrincipal principal;
    private SOAPPrincipalHelper helper;
    private final UserManager userManager;

    public CrowdPropertySet() {
        this(CachingManagerFactory.getUserManagerInstance());
    }

    public CrowdPropertySet(UserManager userManager) {
        this.userManager = userManager;
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        ArrayList<String> foundKeys = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)prefix)) {
            for (String key : this.keys.keySet()) {
                if (!key.startsWith(prefix)) continue;
                foundKeys.add(key);
            }
        }
        return Collections.unmodifiableCollection(foundKeys);
    }

    public int getType(String key) throws PropertyException {
        if (this.exists(key)) {
            return 5;
        }
        return 0;
    }

    public void remove(String key) throws PropertyException {
        if (!this.isSettable(key)) {
            throw new PropertyException("Property with key: '" + key + "' cannot be removed");
        }
        if (this.exists(key)) {
            this.removeAttribute(this.principal, key);
            this.updateUser(this.principal);
        }
    }

    protected void removeAttribute(SOAPPrincipal user, String key) {
        Assert.notNull((Object)user);
        Assert.notNull((Object)key);
        SOAPAttribute[] existingAttributes = user.getAttributes();
        if (existingAttributes != null) {
            ArrayList<SOAPAttribute> newAttributes = new ArrayList<SOAPAttribute>(Arrays.asList(existingAttributes));
            ListIterator<SOAPAttribute> attrIt = newAttributes.listIterator();
            while (attrIt.hasNext()) {
                SOAPAttribute attribute = attrIt.next();
                if (!key.equals(attribute.getName())) continue;
                attrIt.remove();
                break;
            }
            user.setAttributes(this.convertCollectionToSOAPAttributeArray(newAttributes));
        }
    }

    private SOAPAttribute[] convertCollectionToSOAPAttributeArray(Collection col) {
        Assert.notNull((Object)col);
        SOAPAttribute[] attributes = new SOAPAttribute[col.size()];
        int i = 0;
        Iterator colIt = col.iterator();
        while (colIt.hasNext()) {
            attributes[i] = (SOAPAttribute)colIt.next();
            ++i;
        }
        return attributes;
    }

    public boolean exists(String property) throws PropertyException {
        return "email".equals(property) || "fullName".equals(property);
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
        if (!this.isSettable(key)) {
            throw new PropertyException("Property with key: '" + key + "' cannot be set");
        }
        switch (type) {
            case 5: {
                this.setString(key, (String)value);
                return;
            }
            case 1: {
                this.setBoolean(key, (Boolean)value);
                return;
            }
            case 2: {
                this.setInt(key, ((Number)value).intValue());
                return;
            }
            case 3: {
                this.setLong(key, ((Number)value).longValue());
                return;
            }
            case 4: {
                this.setDouble(key, ((Number)value).doubleValue());
                return;
            }
            case 6: {
                this.setText(key, (String)value);
                return;
            }
            case 7: {
                this.setDate(key, (Date)value);
                return;
            }
            case 8: {
                this.setObject(key, value);
                return;
            }
            case 9: {
                this.setXML(key, (Document)value);
                return;
            }
            case 10: {
                this.setData(key, (byte[])value);
                return;
            }
        }
    }

    protected Object get(int type, String key) throws PropertyException {
        if (this.exists(key)) {
            switch (type) {
                case 1: {
                    boolean bool = this.getBoolean(key);
                    if (bool) {
                        return Boolean.TRUE;
                    }
                    if (!this.exists(key)) break;
                    return Boolean.FALSE;
                }
                case 2: {
                    int maybeInt = this.getInt(key);
                    if (maybeInt == 0) break;
                    return new Integer(maybeInt);
                }
                case 3: {
                    long maybeLong = this.getLong(key);
                    if (maybeLong == 0L) break;
                    return new Long(maybeLong);
                }
                case 4: {
                    double maybeDouble = this.getDouble(key);
                    if (maybeDouble == 0.0) break;
                    return new Double(maybeDouble);
                }
                case 5: {
                    String string = this.getString(key);
                    if (string == null) break;
                    return string;
                }
                case 6: {
                    String text = this.getText(key);
                    if (text == null) break;
                    return text;
                }
                case 7: {
                    Date date = this.getDate(key);
                    if (date == null) break;
                    return date;
                }
                case 8: {
                    Object obj = this.getObject(key);
                    if (obj == null) break;
                    return obj;
                }
                case 9: {
                    Document doc = this.getXML(key);
                    if (doc == null) break;
                    return doc;
                }
                case 10: {
                    byte[] data = this.getData(key);
                    if (data == null) break;
                    return data;
                }
                case 11: {
                    Properties p = this.getProperties(key);
                    if (p == null) break;
                    return p;
                }
            }
        }
        return null;
    }

    public void init(Map config, Map args) {
        try {
            this.keys = new HashMap();
            this.keys.put("email", "mail");
            this.keys.put("fullName", "displayName");
            String username = (String)args.get("name");
            this.helper = new SOAPPrincipalHelper();
            this.principal = this.userManager.getUser(username);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isSettable(String property) {
        return "email".equals(property) || "fullName".equals(property);
    }

    public void setString(String property, String value) throws PropertyException {
        if (this.isSettable(property) && StringUtils.isNotBlank((String)value)) {
            this.helper.setProperty(property, value, this.principal);
            this.updateUser(this.principal);
        }
    }

    private void addOrReplaceAttribute(Collection attributes, SOAPAttribute newAttribute) {
        Assert.notNull((Object)attributes);
        Assert.notNull((Object)newAttribute);
        Assert.notNull((Object)newAttribute.getName());
        Assert.notNull((Object)newAttribute.getValues());
        boolean replaced = false;
        for (SOAPAttribute existingAttribute : attributes) {
            if (!newAttribute.getName().equals(existingAttribute.getName())) continue;
            existingAttribute.setValues(new String[]{newAttribute.getValues()[0]});
        }
        if (!replaced) {
            attributes.add(newAttribute);
        }
    }

    private void updateUser(SOAPPrincipal user) throws PropertyException {
        try {
            this.userManager.updateUser(user);
        }
        catch (ApplicationPermissionException e) {
            throw new PropertyException("This application does not have the rights to update " + user.getName() + "'s details.");
        }
        catch (UserNotFoundException e) {
            throw new PropertyException("Could not find " + user.getName() + " to alter their details.");
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public String getString(String property) throws PropertyException {
        String returnValue = null;
        if ("email".equals(property)) {
            String[] email = this.getPropertyValues("mail");
            return email.length > 0 ? email[0] : "";
        }
        if ("fullName".equals(property)) {
            String[] displayName = this.getPropertyValues("displayName");
            return displayName.length > 0 ? displayName[0] : "";
        }
        String[] values = this.getPropertyValues(property);
        returnValue = values.length > 0 && values[0] != null ? values[0] : "";
        return returnValue;
    }

    public boolean supportsType(int type) {
        return type == 5;
    }

    private String[] getPropertyValues(String key) {
        SOAPAttribute[] attributes = this.principal.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(key)) continue;
            return attributes[i].getValues();
        }
        return new String[0];
    }

    public void setKeys(Map keys) {
        this.keys = keys;
    }

    public void setPrincipal(SOAPPrincipal principal) {
        this.principal = principal;
    }
}

