/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.entity;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.integration.rest.entity.AttributeEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="attributes")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AttributeEntityList
implements Attributes,
Iterable<AttributeEntity> {
    @XmlElements(value={@XmlElement(name="attribute")})
    private final List<AttributeEntity> attributes;

    private AttributeEntityList() {
        this.attributes = new ArrayList<AttributeEntity>();
    }

    public AttributeEntityList(List<AttributeEntity> attributes) {
        this.attributes = new ArrayList<AttributeEntity>(attributes);
    }

    public int size() {
        return this.attributes.size();
    }

    @Override
    public Set<String> getValues(String key) {
        return this.asMap().get(key);
    }

    @Override
    public String getValue(String key) {
        AttributeEntity attribute = null;
        for (AttributeEntity attr : this.attributes) {
            if (!attr.getName().equals(key)) continue;
            attribute = attr;
            break;
        }
        if (attribute == null || attribute.getValues() == null || attribute.getValues().isEmpty()) {
            return null;
        }
        return attribute.getValues().iterator().next();
    }

    @Override
    public Set<String> getKeys() {
        return this.asMap().keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public AttributeEntity get(int index) {
        return this.attributes.get(index);
    }

    @Override
    public Iterator<AttributeEntity> iterator() {
        return this.attributes.iterator();
    }

    private Map<String, Set<String>> asMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(this.attributes.size());
        for (AttributeEntity attributeEntity : this.attributes) {
            map.put(attributeEntity.getName(), new HashSet<String>(attributeEntity.getValues()));
        }
        return map;
    }
}

