/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http.filter;

import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.service.client.ClientProperties;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CrowdSecurityFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(CrowdSecurityFilter.class);
    private static final String BASE_NAME = "com.atlassian.crowd.security";
    private static final String FILTER_RUN = "com.atlassian.crowd.security.FILTER_RUN";
    public static final String ORIGINAL_URL = "com.atlassian.crowd.security.ORIGINAL_URL";
    public static final String LAST_VALIDATED = "com.atlassian.crowd.security.LAST_VALIDATED";
    private final CrowdHttpAuthenticator httpAuthenticator;
    private final ClientProperties clientProperties;

    public CrowdSecurityFilter(CrowdHttpAuthenticator httpAuthenticator, ClientProperties clientProperties) {
        this.httpAuthenticator = httpAuthenticator;
        this.clientProperties = clientProperties;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Date filterStart = new Date();
        boolean isValidated = false;
        try {
            Boolean filterRun = (Boolean)servletRequest.getAttribute(FILTER_RUN);
            if (filterRun != null && filterRun.booleanValue()) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                servletRequest.setAttribute(FILTER_RUN, (Object)Boolean.TRUE);
                HttpServletRequest request = (HttpServletRequest)servletRequest;
                HttpServletResponse response = (HttpServletResponse)servletResponse;
                isValidated = this.httpAuthenticator.isAuthenticated(request, response);
                StringBuffer originalURL = request.getRequestURL();
                boolean foundParameter = false;
                if (request.getParameterMap().size() > 0) {
                    originalURL.append("?");
                    Enumeration params = request.getParameterNames();
                    while (params.hasMoreElements()) {
                        if (!foundParameter) {
                            foundParameter = true;
                        } else {
                            originalURL.append("&");
                        }
                        String name = (String)params.nextElement();
                        String[] values = request.getParameterValues(name);
                        for (int i = 0; i < values.length; ++i) {
                            originalURL.append(name).append("=").append(values[i]);
                        }
                    }
                }
                if (!isValidated) {
                    logger.info((Object)("Requesting URL is: " + originalURL));
                    request.getSession().setAttribute(ORIGINAL_URL, (Object)originalURL.toString());
                    logger.info((Object)("Authentication is not valid, redirecting to: " + this.clientProperties.getApplicationAuthenticationURL()));
                    response.sendRedirect(this.clientProperties.getApplicationAuthenticationURL());
                } else {
                    request.removeAttribute(ORIGINAL_URL);
                    filterChain.doFilter(servletRequest, servletResponse);
                    if (servletRequest.getAttribute(FILTER_RUN) != null) {
                        servletRequest.removeAttribute(FILTER_RUN);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (logger.isDebugEnabled()) {
                Date now = new Date();
                logger.debug((Object)("Filter time to run: " + (now.getTime() - filterStart.getTime()) + " ms"));
            }
        }
    }
}

