/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.service.AuthenticationManager;
import com.atlassian.crowd.integration.springsecurity.CrowdAuthenticationProvider;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import java.rmi.RemoteException;
import org.springframework.dao.DataAccessException;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class RemoteCrowdAuthenticationProvider
extends CrowdAuthenticationProvider {
    protected final AuthenticationManager authenticationManager;
    protected final HttpAuthenticator httpAuthenticator;
    protected final CrowdUserDetailsService userDetailsService;

    public RemoteCrowdAuthenticationProvider(AuthenticationManager authenticationManager, HttpAuthenticator httpAuthenticator, CrowdUserDetailsService userDetailsService) {
        super(httpAuthenticator.getClientProperties().getApplicationName());
        this.authenticationManager = authenticationManager;
        this.httpAuthenticator = httpAuthenticator;
        this.userDetailsService = userDetailsService;
    }

    protected boolean isAuthenticated(String token, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, RemoteException, ApplicationAccessDeniedException {
        return this.authenticationManager.isAuthenticated(token, validationFactors);
    }

    protected String authenticate(String username, String password, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        return this.httpAuthenticator.verifyAuthentication(username, password, validationFactors);
    }

    protected CrowdUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.userDetailsService.loadUserByUsername(username);
    }

    protected CrowdUserDetails loadUserByToken(String token) throws CrowdSSOTokenInvalidException, DataAccessException {
        return this.userDetailsService.loadUserByToken(token);
    }
}

