/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SOAPPrincipalHelper {
    private Map keys;

    public SOAPPrincipalHelper(Map keys) {
        this.keys = keys;
    }

    public SOAPPrincipalHelper() {
        this.keys = new HashMap();
        this.keys.put("email", "mail");
        this.keys.put("fullName", "displayName");
    }

    public void setFullName(String fullname, SOAPPrincipal principal) {
        this.setProperty("fullName", fullname, principal);
    }

    public void setEmail(String email, SOAPPrincipal principal) {
        this.setProperty("email", email, principal);
    }

    public void setProperty(String property, String value, SOAPPrincipal principal) {
        ArrayList<SOAPAttribute> newAttributes = new ArrayList<SOAPAttribute>();
        SOAPAttribute[] existingAttributes = principal.getAttributes();
        if (existingAttributes != null) {
            newAttributes.addAll(Arrays.asList(existingAttributes));
        }
        if ("fullName".equals(property)) {
            Collection newValues = this.splitFullnameIntoSOAPAttributes(value);
            if (newValues != null) {
                for (SOAPAttribute newVal : newValues) {
                    this.addOrReplaceAttribute(newAttributes, newVal);
                }
            }
        } else {
            this.addOrReplaceAttribute(newAttributes, new SOAPAttribute((String)this.keys.get(property), value));
        }
        principal.setAttributes(newAttributes.toArray(new SOAPAttribute[newAttributes.size()]));
    }

    private void addOrReplaceAttribute(Collection attributes, SOAPAttribute newAttribute) {
        Assert.notNull(attributes);
        Assert.notNull(newAttribute);
        Assert.notNull(newAttribute.getName());
        Assert.notNull(newAttribute.getValues());
        boolean replaced = false;
        for (SOAPAttribute existingAttribute : attributes) {
            if (!newAttribute.getName().equals(existingAttribute.getName())) continue;
            existingAttribute.setValues(new String[]{newAttribute.getValues()[0]});
        }
        if (!replaced) {
            attributes.add(newAttribute);
        }
    }

    protected Collection splitFullnameIntoSOAPAttributes(String fullname) {
        ArrayList<SOAPAttribute> soapAttributes = new ArrayList<SOAPAttribute>();
        String[] strings = StringUtils.split((String)fullname, (String)" ", (int)2);
        if (strings.length > 1) {
            soapAttributes.add(new SOAPAttribute("givenName", strings[0]));
            soapAttributes.add(new SOAPAttribute("sn", strings[1]));
        } else if (strings.length > 0) {
            soapAttributes.add(new SOAPAttribute("givenName", strings[0]));
            soapAttributes.add(new SOAPAttribute("sn", " "));
        } else {
            soapAttributes.add(new SOAPAttribute("givenName", " "));
            soapAttributes.add(new SOAPAttribute("sn", " "));
        }
        soapAttributes.add(new SOAPAttribute("displayName", fullname));
        return soapAttributes;
    }
}

