/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.util;

import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import org.apache.commons.lang.StringUtils;

public class SOAPPrincipalHelper {
    public String getFirstName(SOAPPrincipal principal) {
        return this.getFirstAttributeValue("givenName", principal);
    }

    public String getLastName(SOAPPrincipal principal) {
        return this.getFirstAttributeValue("sn", principal);
    }

    public String getEmail(SOAPPrincipal principal) {
        return this.getFirstAttributeValue("mail", principal);
    }

    public String getIconLocation(SOAPPrincipal principal) {
        return this.getFirstAttributeValue("iconLocation", principal);
    }

    public String getFirstAttributeValue(String name, SOAPPrincipal principal) {
        SOAPAttribute attribute = this.getAttribute(name, principal);
        if (attribute != null && attribute.getValues() != null && attribute.getValues().length > 0) {
            return attribute.getValues()[0];
        }
        return null;
    }

    public SOAPAttribute getAttribute(String name, SOAPPrincipal principal) {
        SOAPAttribute[] attributes = principal.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals(name)) continue;
                return attributes[i];
            }
        }
        return null;
    }

    public String getFullName(SOAPPrincipal principal) {
        String displayName = this.getFirstAttributeValue("displayName", principal);
        if (!StringUtils.isEmpty((String)displayName)) {
            return displayName;
        }
        return this.getFirstAttributeValue("givenName", principal) + " " + this.getFirstAttributeValue("sn", principal);
    }
}

