/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;

public class PrioritizedCompositePropertySet
extends AbstractPropertySet {
    private final List delegates;

    PrioritizedCompositePropertySet(List delegates) {
        Iterator it = delegates.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof PropertySet) continue;
            throw new IllegalArgumentException("Can only delegate to PropertySet implementations!");
        }
        this.delegates = Collections.unmodifiableList(new ArrayList(delegates));
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        HashSet result = new HashSet();
        for (PropertySet propertySet : this.delegates) {
            result.addAll(propertySet.getKeys(prefix, type));
        }
        return result;
    }

    public int getType(String key) throws PropertyException {
        for (PropertySet propertySet : this.delegates) {
            if (!propertySet.exists(key)) continue;
            return propertySet.getType(key);
        }
        return 0;
    }

    public boolean exists(String key) throws PropertyException {
        for (PropertySet propertySet : this.delegates) {
            if (!propertySet.exists(key)) continue;
            return true;
        }
        return false;
    }

    public void remove(String key) throws PropertyException {
        if (!this.isSettable(key)) {
            throw new PropertyException("Property with key: '" + key + "' cannot be removed");
        }
        boolean removed = false;
        for (PropertySet set : this.delegates) {
            if (!set.exists(key)) continue;
            if (set.isSettable(key)) {
                set.remove(key);
                removed = true;
                continue;
            }
            if (removed) continue;
            throw new PropertyException("Property with key: '" + key + "' cannot be removed");
        }
    }

    public boolean isSettable(String property) {
        if (this.exists(property)) {
            for (PropertySet set : this.delegates) {
                if (!set.exists(property) || set.isSettable(property)) continue;
                return false;
            }
            return true;
        }
        for (PropertySet set : this.delegates) {
            if (!set.isSettable(property)) continue;
            return true;
        }
        return false;
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
        if (!this.isSettable(key)) {
            throw new PropertyException("Property with key: '" + key + "' cannot be set");
        }
        for (PropertySet set : this.delegates) {
            if (!set.isSettable(key)) continue;
            switch (type) {
                case 1: {
                    set.setBoolean(key, ((Boolean)value).booleanValue());
                    return;
                }
                case 2: {
                    set.setInt(key, ((Number)value).intValue());
                    return;
                }
                case 3: {
                    set.setLong(key, ((Number)value).longValue());
                    return;
                }
                case 4: {
                    set.setDouble(key, ((Number)value).doubleValue());
                    return;
                }
                case 5: {
                    set.setString(key, (String)value);
                    return;
                }
                case 6: {
                    set.setText(key, (String)value);
                    return;
                }
                case 7: {
                    set.setDate(key, (Date)value);
                    return;
                }
                case 8: {
                    set.setObject(key, value);
                    return;
                }
                case 9: {
                    set.setXML(key, (Document)value);
                    return;
                }
                case 10: {
                    set.setData(key, (byte[])value);
                    return;
                }
            }
        }
    }

    protected Object get(int type, String key) throws PropertyException {
        for (PropertySet set : this.delegates) {
            if (!set.exists(key)) continue;
            switch (type) {
                case 1: {
                    boolean bool = set.getBoolean(key);
                    if (bool) {
                        return Boolean.TRUE;
                    }
                    if (!set.exists(key)) break;
                    return Boolean.FALSE;
                }
                case 2: {
                    int maybeInt = set.getInt(key);
                    if (maybeInt == 0) break;
                    return new Integer(maybeInt);
                }
                case 3: {
                    long maybeLong = set.getLong(key);
                    if (maybeLong == 0L) break;
                    return new Long(maybeLong);
                }
                case 4: {
                    double maybeDouble = set.getDouble(key);
                    if (maybeDouble == 0.0) break;
                    return new Double(maybeDouble);
                }
                case 5: {
                    String string = set.getString(key);
                    if (string == null) break;
                    return string;
                }
                case 6: {
                    String text = set.getText(key);
                    if (text == null) break;
                    return text;
                }
                case 7: {
                    Date date = set.getDate(key);
                    if (date == null) break;
                    return date;
                }
                case 8: {
                    Object obj = set.getObject(key);
                    if (obj == null) break;
                    return obj;
                }
                case 9: {
                    Document doc = set.getXML(key);
                    if (doc == null) break;
                    return doc;
                }
                case 10: {
                    byte[] data = set.getData(key);
                    if (data == null) break;
                    return data;
                }
                case 11: {
                    Properties p = set.getProperties(key);
                    if (p == null) break;
                    return p;
                }
            }
        }
        return null;
    }
}

