/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.fisheye;

import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.cenqua.fisheye.user.plugin.AuthToken;
import org.apache.log4j.Logger;

public class FisheyeAuthToken
implements AuthToken {
    private static final Logger logger = Logger.getLogger(FisheyeAuthToken.class);
    SOAPPrincipal principal;
    String displayName;
    String email;

    public FisheyeAuthToken(SOAPPrincipal principal) {
        this.principal = principal;
        this.processAll();
    }

    public String getUsername() {
        return this.principal.getName();
    }

    public String getEmail() {
        return this.email;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private void processAll() {
        try {
            this.processEmail();
            this.processFullName();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void processFullName() {
        String[] fn = this.getPropertyValues("givenName");
        String[] ln = this.getPropertyValues("sn");
        StringBuffer fullName = new StringBuffer();
        if (fn.length > 0) {
            fullName.append(fn[0]);
        }
        if (ln.length > 0) {
            if (fullName.length() > 0) {
                fullName.append(" ");
            }
            fullName.append(ln[0]);
        }
        this.displayName = fullName.toString();
    }

    protected void processEmail() {
        String[] email = this.getPropertyValues("mail");
        this.email = email.length > 0 ? email[0] : "";
    }

    protected String[] getPropertyValues(String key) {
        if (this.principal != null) {
            SOAPAttribute[] attributes = this.principal.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals(key)) continue;
                return attributes[i].getValues();
            }
        }
        return new String[0];
    }
}

