/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.GroupManager;
import com.atlassian.crowd.integration.service.cache.BasicCache;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.crowd.integration.util.Assert;
import com.atlassian.crowd.integration.util.NestingHelper;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;

public class CachingGroupManager
implements GroupManager {
    private final Server server;
    private final BasicCache basicCache;

    public CachingGroupManager(SecurityServerClient securityServerClient, BasicCache basicCache) {
        this.server = new Server(securityServerClient);
        this.basicCache = basicCache;
    }

    public boolean isGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException {
        Assert.notNull(groupName);
        List groupNames = this.getAllGroupNames();
        if (groupNames != null) {
            return groupNames.contains(groupName);
        }
        return false;
    }

    public SOAPGroup getGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        Assert.notNull(groupName);
        SOAPGroup group = this.basicCache.getGroup(groupName);
        if (group == null) {
            group = this.server.getGroup(groupName);
            this.basicCache.setMembers(groupName, group.getMembers());
            this.basicCache.addOrReplaceGroup(group);
        }
        group.setMembers(null);
        return group;
    }

    public SOAPGroup addGroup(SOAPGroup group) throws RemoteException, InvalidGroupException, InvalidAuthorizationTokenException, ApplicationPermissionException {
        Assert.notNull(group);
        Assert.notNull(group.getName());
        group = this.server.addGroup(group);
        this.basicCache.addOrReplaceGroup(group);
        this.basicCache.addToAllGroupNamesCache(group.getName());
        return group;
    }

    public List searchGroups(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException {
        return this.server.searchGroups(restrictions);
    }

    public void updateGroup(SOAPGroup group) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
        Assert.notNull(group);
        this.server.updateGroup(group);
        this.basicCache.addOrReplaceGroup(group);
    }

    public void removeGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Assert.notNull(groupName);
        this.server.removeGroup(groupName);
        this.basicCache.removeGroup(groupName);
        this.basicCache.removeCachedGroupMemberships(groupName);
        this.basicCache.removeFromAllGroupNamesCache(groupName);
    }

    public List getAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException {
        List groupNames = this.basicCache.getAllGroupNames();
        if (groupNames == null) {
            groupNames = this.server.getAllGroupNames();
            this.basicCache.addOrReplaceAllGroupNames(groupNames);
        }
        return groupNames;
    }

    private class Server {
        private final SecurityServerClient ssc;

        public Server(SecurityServerClient securityServerClient) {
            this.ssc = securityServerClient;
        }

        public SOAPGroup getGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
            return this.ssc.findGroupByName(groupName);
        }

        public List searchGroups(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException {
            SOAPGroup[] groups = this.ssc.searchGroups(restrictions);
            return Arrays.asList(groups);
        }

        public SOAPGroup addGroup(SOAPGroup group) throws RemoteException, ApplicationPermissionException, InvalidAuthorizationTokenException, InvalidGroupException {
            return this.ssc.addGroup(group);
        }

        public void updateGroup(SOAPGroup group) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
            this.ssc.updateGroup(group.getName(), group.getDescription(), group.isActive());
        }

        public void removeGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
            this.ssc.removeGroup(groupName);
        }

        public List getAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException {
            SOAPNestableGroup[] allGroups = this.ssc.findAllGroupRelationships();
            if (allGroups == null) {
                return null;
            }
            return NestingHelper.getAllGroupNames(allGroups, CachingGroupManager.this.basicCache);
        }
    }
}

